/*
 * Decompiled with CFR 0.152.
 */
package toad4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import toad4.ToadComm;

public class ToadCommSerial
implements ToadComm {
    private volatile InputStream m_InputStream;
    private volatile OutputStream m_OutputStream;
    private volatile SerialPort m_CommPort;

    @Override
    public void closeConnection() {
        if (this.m_CommPort != null) {
            try {
                this.m_InputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.m_OutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.m_CommPort.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.m_CommPort = null;
        }
    }

    @Override
    public void openConnection(String string) throws ToadComm.DeviceBusyException, ToadComm.DeviceNotFound, IOException {
        if (this.m_CommPort == null) {
            CommPortIdentifier commPortIdentifier = null;
            try {
                System.out.print("attempt to open port: '" + string + "'... ");
                commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
                this.m_CommPort = (SerialPort)commPortIdentifier.open("EazyCNC", 10);
                this.m_CommPort.enableReceiveTimeout(100);
                this.m_CommPort.setFlowControlMode(0);
                this.m_CommPort.setSerialPortParams(9600, 8, 1, 0);
                this.m_InputStream = this.m_CommPort.getInputStream();
                while (this.m_InputStream.available() > 0) {
                    this.m_InputStream.read();
                }
                this.m_OutputStream = this.m_CommPort.getOutputStream();
                System.out.print("ok");
            }
            catch (NoSuchPortException noSuchPortException) {
                System.out.print("no such port");
                throw new ToadComm.DeviceNotFound();
            }
            catch (PortInUseException portInUseException) {
                System.out.print("port busy: " + portInUseException.getMessage());
                throw new ToadComm.DeviceBusyException();
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                System.out.println("did not support our settings");
                throw new IOException("UnsupportedCommOperationException on port " + commPortIdentifier.getName());
            }
            finally {
                System.out.println();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.m_CommPort != null;
    }

    @Override
    public void write(byte[] byArray, int n) throws Exception {
        this.m_OutputStream.write(byArray, 0, n);
    }

    @Override
    public int read(byte[] byArray, int n) throws Exception {
        int n2;
        if (n == 0) {
            n = this.m_InputStream.read();
            if (n == 0) {
                throw new ToadComm.TimeoutException();
            }
            if (n < 0) {
                return 0;
            }
            if (n < 128) {
                return 0;
            }
            byArray[0] = (byte)n;
            n2 = (n &= 0x7F) - 1;
        } else {
            n2 = n;
        }
        while (n2 > 0) {
            int n3 = this.m_InputStream.read(byArray, n - n2, n2);
            if (n3 == 0) {
                throw new ToadComm.TimeoutException();
            }
            if (n3 < 0) break;
            n2 -= n3;
        }
        return n - n2;
    }

    @Override
    public void flush() throws InterruptedException, IOException {
        int n = 0;
        do {
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.m_InputStream.read();
                }
            }
            Thread.sleep(10L);
        } while ((n = this.m_InputStream.available()) > 0);
    }
}

