/*
 * Decompiled with CFR 0.152.
 */
package toad4plus;

import com.eazycnc.plugin.ConnectionState;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.List;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.PureJavaHidApi;
import toad4plus.Toad4PlusMotorController;

public class Toad4PlusComm
implements Toad4PlusMotorController.ToadPlusCommInterface {
    private volatile HidDevice m_Device;
    private volatile boolean m_MessageReceived;
    private volatile Object m_InputMessageSema4 = new Object();
    private volatile byte m_InputMessageId;
    private volatile byte m_OutputMessageId;
    private volatile byte[] m_InputData;
    private static final short VID = 7504;
    private static final short PID = 24608;
    private boolean m_AccessDenied;

    private HidDevice openDevice() throws IOException {
        List list = PureJavaHidApi.enumerateDevices();
        for (HidDeviceInfo hidDeviceInfo : list) {
            if (hidDeviceInfo.getVendorId() != 7504 || hidDeviceInfo.getProductId() != 24608) continue;
            return PureJavaHidApi.openDevice((HidDeviceInfo)hidDeviceInfo);
        }
        return null;
    }

    @Override
    public boolean getAccessDenied() {
        return this.m_AccessDenied;
    }

    @Override
    public ConnectionState tryToOpenDevice() {
        System.out.println("OPEN DEVICE");
        if (this.m_Device != null) {
            return ConnectionState.CONNECTED;
        }
        try {
            this.m_Device = this.openDevice();
            this.m_AccessDenied = false;
            if (this.m_Device == null) {
                return ConnectionState.DEVICE_NOT_FOUND;
            }
            this.m_Device.setInputReportListener((hidDevice, by, byArray, n) -> this.handleInputMessage(byArray));
            return ConnectionState.CONNECTED;
        }
        catch (AccessDeniedException accessDeniedException) {
            this.m_AccessDenied = true;
            return ConnectionState.ACCESS_DENIED;
        }
        catch (IOException iOException) {
            this.m_AccessDenied = false;
            return ConnectionState.DEVICE_NOT_RESPONDING;
        }
    }

    @Override
    public ConnectionState tryToCloseDevice() {
        System.out.println("CLOSE DEVICE");
        try {
            if (this.m_Device != null) {
                this.m_Device.close();
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_Device = null;
        return ConnectionState.SHUTDOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInputMessage(byte[] byArray) {
        Object object = this.m_InputMessageSema4;
        synchronized (object) {
            this.m_MessageReceived = true;
            this.m_InputMessageId = byArray[63];
            this.m_InputData = new byte[64];
            System.arraycopy(byArray, 0, this.m_InputData, 0, this.m_InputData.length);
            this.m_InputMessageSema4.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sendMessage(byte[] byArray) throws IOException, InterruptedException {
        if (this.m_Device != null) {
            byArray[63] = this.m_OutputMessageId = (byte)(this.m_OutputMessageId + 1);
            this.m_Device.setOutputReport((byte)0, byArray, 64);
            Object object = this.m_InputMessageSema4;
            synchronized (object) {
                int n = 0;
                while (this.m_InputMessageId != this.m_OutputMessageId) {
                    this.m_MessageReceived = false;
                    this.m_InputMessageSema4.wait(200L);
                    if (this.m_MessageReceived) continue;
                    if (++n > 3) {
                        System.err.println("Toad4PlusComm.sendMessage(): timeout/fail");
                        throw new IOException("Maximum number of timouts exceeded");
                    }
                    System.err.println("Toad4PlusComm.sendMessage(): timeout/retrying");
                }
            }
            return this.m_InputData;
        }
        throw new IOException("Device not open");
    }
}

