/*
 * Decompiled with CFR 0.152.
 */
package toad4plus;

import com.eazycnc.motorcontroller.MotorController;
import com.eazycnc.uwk.Observer;
import eazycnc.gcode.MachState;
import java.util.EnumSet;
import toad4plus.Toad4PlusMotorController;
import toad4plus.simulator.Toad4PlusSimulator2;

public final class Toad4PlusMotor {
    boolean FW201 = true;
    static final EnumSet<State> m_JogStates = EnumSet.range(State.JOG_START, State.JOG_STOPPING);
    static final EnumSet<State> m_HomingStates = EnumSet.range(State.HOME_START, State.RESET_POSITION);
    static final int CMD_NOP = 0;
    static final int CMD_MOVE = 1;
    static final int CMD_RESET_POSITION = 2;
    static final int CMD_REINIT_MOTOR = 3;
    static final int CMD_RESET_MOTOR = 4;
    private Toad4PlusMotorController m_Controller;
    private double m_UnitSize;
    private static int m_MaxVelo;
    private static int m_MaxTravel;
    private volatile double m_StepsPerCycletime2Speed;
    private volatile double m_Speed2StepsPerCycletime;
    private volatile double m_Cycletime;
    private volatile int m_QueueSize;
    private volatile int m_QueueCapacity;
    private volatile boolean m_IsMachMotor;
    private volatile boolean m_QueueFull;
    private volatile boolean m_QueueEmpty;
    private volatile State m_State = State.IDLE;
    private volatile int m_CurrentSpeed;
    private volatile boolean m_CurrentDir;
    private volatile boolean m_JogForward;
    private volatile int m_JogStepsLeft;
    private volatile int m_JogStepSpeed;
    private volatile int m_JogSlowSpeed;
    private volatile int m_JogFastSpeed;
    private volatile int m_JogSpeed;
    private volatile int m_JogStepLength;
    private volatile int m_JogAcceleration;
    private int m_JogMode = 0;
    private volatile int m_HomingMaxSpeed;
    private volatile int m_HomingCrawlSpeed;
    private volatile int m_HomingAcceleration;
    private volatile int m_HomingOvershoot;
    private volatile boolean m_LimitsEnable;
    private volatile int m_LimitPositionMin;
    private volatile int m_LimitPositionMax;
    private double m_StepSize;
    volatile int m_HomePolarity;
    volatile boolean m_DirPolarity;
    private volatile boolean m_HomeInput;
    private volatile boolean m_HomeActive;
    private volatile int m_SetMotorPositionTo;
    private volatile int m_Position;
    private volatile int m_PlannedMotorPosition;
    private volatile boolean m_InvertEnable;
    private volatile int m_Offset;
    private volatile byte[] m_MessageData;
    private int m_TimeOutResetValue;
    private int m_Timeout;
    private int m_GroupId;
    private int m_CurrentMode;
    private volatile double m_NCOSize = 65536.0;
    private volatile double m_NCOFreq = 100000.0;
    private volatile int m_Axis = -1;
    private volatile int m_Motor;
    private volatile MachState m_MachState;
    private volatile Observer m_MachStateObserver;
    private volatile int m_SlaveMotor = -1;
    private volatile int m_MasterMotor = -1;
    private int m_HomeStartOfBraking = 0;
    private boolean m_PositionReset;
    int m_MpgTargetPosition = 0;
    int m_MpgPosition = 0;
    int m_MpgSpeed = 0;
    int m_MpgDir = 0;
    int m_MpgTargetSpeed = 0;
    private Toad4PlusSimulator2 m_Simulator;
    State state0;

    Toad4PlusMotor(Toad4PlusMotorController toad4PlusMotorController, Toad4PlusSimulator2 toad4PlusSimulator2, MachState machState, int n, byte[] byArray, int n2, int n3) {
        this.m_Controller = toad4PlusMotorController;
        this.m_Simulator = toad4PlusSimulator2;
        m_MaxVelo = n2;
        m_MaxTravel = n3;
        this.m_Motor = n;
        this.m_GroupId = n + 1;
        this.m_Offset = n * 8;
        this.m_MessageData = byArray;
        this.m_MachState = machState;
        this.m_MachStateObserver = observable -> this.reconfigureMotor();
        this.m_MachState.getVariable(15176).addObserver(observable -> this.m_Simulator.setProbePolarity(this.m_MachState.getParamBoolean(15176)));
        this.m_MachState.getVariable(15150).addObserver(this.m_MachStateObserver);
        this.m_MachState.getVariable(15168).addObserver(observable -> {
            this.m_JogMode = machState.getParamInt(15168);
        });
        this.m_MachState.getVariable(15141).addObserver(observable -> {
            this.m_UnitSize = machState.getParamDouble(15141);
        });
    }

    public int getSlave() {
        return this.m_SlaveMotor;
    }

    public int getMaster() {
        return this.m_MasterMotor;
    }

    boolean isHoming() {
        return m_HomingStates.contains((Object)this.m_State);
    }

    boolean isPositionReset() {
        return this.m_PositionReset;
    }

    private void updateDependency(int n, int n2, int n3) {
        if (n2 >= 0) {
            this.m_MachState.getVariable(n, n2).removeObserver(this.m_MachStateObserver);
        }
        if (n3 >= 0) {
            this.m_MachState.getVariable(n, n3).addObserver(this.m_MachStateObserver);
        }
    }

    public void assignAxis(int n, int n2, int n3) {
        this.m_MasterMotor = n2;
        this.m_SlaveMotor = n3;
        int n4 = this.m_Axis;
        this.m_Axis = n;
        this.updateDependency(-2147483646, n4, n);
        this.updateDependency(0x20000002, n4, n);
        this.updateDependency(0x20000001, n4, n);
        this.updateDependency(0x20000000, n4, n);
        this.updateDependency(0x20000000, n4, n);
        this.updateDependency(0x20000001, n4, n);
        this.updateDependency(0x20000004, n4, n);
        this.updateDependency(0x20000000, n4, n);
        this.updateDependency(-2147483640, n4, n);
        this.updateDependency(-2147483642, n4, n);
        this.updateDependency(-2147483641, n4, n);
        this.updateDependency(-2147483644, n4, n);
        this.updateDependency(-2147483643, n4, n);
        this.updateDependency(Integer.MIN_VALUE, n4, n);
        this.updateDependency(-2147483634, n4, n);
        this.updateDependency(-2147483635, n4, n);
        this.updateDependency(-2147483636, n4, n);
        this.updateDependency(-2147483645, n4, n);
        this.updateDependency(-2147483632, n4, n);
    }

    public MotorController.MotorState getMotorState() {
        State state = this.m_State;
        if (state == State.IDLE) {
            return MotorController.MotorState.READY;
        }
        if (state == State.RUNNING) {
            return MotorController.MotorState.RUNNING;
        }
        if (m_HomingStates.contains((Object)state)) {
            return MotorController.MotorState.HOMING;
        }
        if (m_JogStates.contains((Object)state)) {
            return MotorController.MotorState.JOGGING;
        }
        return MotorController.MotorState.BUSY;
    }

    private void reconfigureMotor(int n) {
        MachState machState = this.m_MachState;
        double d = this.m_NCOSize / this.m_NCOFreq;
        double d2 = machState.getParamDouble(-2147483646, n);
        double d3 = machState.getParamDouble(15150);
        this.m_StepSize = d2;
        this.m_Cycletime = d3;
        this.m_StepsPerCycletime2Speed = d / this.m_Cycletime;
        this.m_Speed2StepsPerCycletime = this.m_Cycletime / d;
        this.m_JogAcceleration = (int)(machState.getParamDouble(0x20000002, n) * d2 * d3);
        this.m_HomingAcceleration = (int)(machState.getParamDouble(-2147483634, n) * d2 * d3);
        this.m_HomingMaxSpeed = (int)(machState.getParamDouble(-2147483635, n) * d2 * d3 * this.m_StepsPerCycletime2Speed);
        this.m_HomingCrawlSpeed = (int)(machState.getParamDouble(-2147483636, n) * d2 * d3 * this.m_StepsPerCycletime2Speed);
        this.m_JogSlowSpeed = (int)(machState.getParamDouble(0x20000000, n) * d2 * d3 * this.m_StepsPerCycletime2Speed);
        this.m_JogFastSpeed = (int)(machState.getParamDouble(0x20000001, n) * d2 * d3 * this.m_StepsPerCycletime2Speed);
        this.m_JogStepLength = (int)(machState.getParamDouble(0x20000004, n) * d2);
        this.m_JogStepSpeed = (int)(machState.getParamDouble(0x20000000, n) * d2 * d3 * this.m_StepsPerCycletime2Speed);
        this.m_LimitsEnable = machState.getParamBoolean(-2147483640, n);
        this.m_LimitPositionMin = (int)(machState.getParamDouble(-2147483642, n) * d2);
        this.m_LimitPositionMax = (int)(machState.getParamDouble(-2147483641, n) * d2);
        this.m_HomePolarity = machState.getParamInt(-2147483644, n);
        this.m_DirPolarity = machState.getParamInt(-2147483643, n) == 1;
        this.m_IsMachMotor = machState.getParamBoolean(-2147483645, n);
        this.m_TimeOutResetValue = (int)(2.0 / d3);
        this.m_CurrentMode = machState.getParamInt(Integer.MIN_VALUE, n);
        this.m_InvertEnable = machState.getParamBoolean(-2147483632, n);
        this.m_Simulator.setPolarities(this.m_Motor, this.m_HomePolarity == 1, this.m_DirPolarity);
        this.m_Simulator.setStepSize(this.m_Motor, this.m_StepSize);
    }

    private void reconfigureMotor() {
        if (this.m_Axis < 0) {
            return;
        }
        if (this.m_MasterMotor >= 0) {
            this.m_Controller.m_Motors[this.m_MasterMotor].reconfigureMotor(this.m_Axis);
        }
        if (this.m_SlaveMotor >= 0) {
            this.m_Controller.m_Motors[this.m_SlaveMotor].reconfigureMotor(this.m_Axis);
        }
    }

    boolean startJogging(boolean bl) throws Exception {
        if (this.m_State != State.IDLE && this.m_State != State.JOG_STOPPING) {
            return false;
        }
        if (this.m_LimitsEnable) {
            if (bl && this.m_Position >= this.m_LimitPositionMax) {
                return false;
            }
            if (!bl && this.m_Position <= this.m_LimitPositionMin) {
                return false;
            }
        }
        if (this.m_State == State.IDLE) {
            this.m_CurrentSpeed = 0;
        }
        this.m_State = State.JOG_START;
        this.m_JogForward = bl;
        return true;
    }

    void stopJogging() {
        if (!m_JogStates.contains((Object)this.m_State)) {
            return;
        }
        if (this.m_State == State.JOG_STEP) {
            return;
        }
        this.m_State = State.JOG_STOPPING;
    }

    void startHoming(int n) {
        if (this.m_State != State.IDLE) {
            return;
        }
        this.m_State = State.HOME_START;
        this.m_SetMotorPositionTo = n;
    }

    void stopHoming() {
        if (!m_HomingStates.contains((Object)this.m_State)) {
            return;
        }
        this.m_State = State.HOME_STOP;
    }

    void setPosition(int n) {
        if (this.m_State != State.IDLE) {
            return;
        }
        this.m_SetMotorPositionTo = n;
        this.m_State = State.RESET_POSITION;
    }

    int getPosition() {
        return this.m_Position;
    }

    void handleJog() {
        State state;
        if (this.m_QueueSize > 2) {
            return;
        }
        int n = this.m_LimitsEnable ? (this.m_JogForward ? this.m_LimitPositionMax - this.m_Position : this.m_Position - this.m_LimitPositionMin) : Integer.MAX_VALUE;
        block17: do {
            state = this.m_State;
            block0 : switch (this.m_State) {
                default: {
                    break;
                }
                case JOG_START: {
                    switch (this.m_JogMode) {
                        case 0: {
                            this.m_JogSpeed = this.m_JogFastSpeed;
                            this.m_JogStepsLeft = this.m_JogStepLength;
                            this.m_State = State.JOG_FAST;
                            break block0;
                        }
                        case 1: {
                            this.m_JogSpeed = this.m_JogSlowSpeed;
                            this.m_JogStepsLeft = this.m_JogStepLength;
                            this.m_State = State.JOG_SLOW;
                            break block0;
                        }
                        case 6: {
                            this.m_JogStepsLeft = 1;
                            this.m_State = State.JOG_STEP;
                            break block0;
                        }
                        case 5: {
                            this.m_JogStepsLeft = (int)(0.001 * this.m_StepSize * this.m_UnitSize);
                            this.m_State = State.JOG_STEP;
                            break block0;
                        }
                        case 4: {
                            this.m_JogStepsLeft = (int)(0.01 * this.m_StepSize * this.m_UnitSize);
                            this.m_State = State.JOG_STEP;
                            break block0;
                        }
                        case 3: {
                            this.m_JogStepsLeft = (int)(0.1 * this.m_StepSize * this.m_UnitSize);
                            this.m_State = State.JOG_STEP;
                            break block0;
                        }
                        case 2: {
                            this.m_JogStepsLeft = (int)(1.0 * this.m_StepSize * this.m_UnitSize);
                            this.m_State = State.JOG_STEP;
                            break block0;
                        }
                    }
                    this.m_State = State.JOG_STOPPING;
                    break;
                }
                case JOG_SLOW: 
                case JOG_FAST: {
                    double d = (double)this.m_CurrentSpeed * this.m_Cycletime / (double)this.m_JogAcceleration;
                    double d2 = (double)this.m_JogAcceleration * this.m_Speed2StepsPerCycletime / (this.m_Cycletime * this.m_Cycletime);
                    int n2 = (int)(0.5 * d2 * (d += this.m_Cycletime * 2.0) * d);
                    if (n > n2) {
                        this.accelerate(this.m_JogForward, this.m_JogSpeed, this.m_JogAcceleration);
                        break;
                    }
                    this.m_State = State.JOG_DECELEREATE_TO_LIMIT;
                    break;
                }
                case JOG_DECELEREATE_TO_LIMIT: {
                    this.m_CurrentSpeed -= this.m_JogAcceleration;
                    int n3 = (int)((double)this.m_CurrentSpeed * this.m_Speed2StepsPerCycletime);
                    if (this.m_CurrentSpeed > 0 && n3 > 0) {
                        this.move(this.m_JogForward, n3, this.m_CurrentSpeed);
                        break;
                    }
                    this.m_State = State.JOG_CRAWL_TO_LIMIT;
                    break;
                }
                case JOG_CRAWL_TO_LIMIT: {
                    if (n > 0) {
                        if (this.m_QueueSize != 0) continue block17;
                        this.move(this.m_JogForward, 1, (int)this.m_StepsPerCycletime2Speed);
                        break;
                    }
                    this.m_State = State.JOG_STOPPING;
                    break;
                }
                case JOG_STEP: {
                    if (this.m_JogStepsLeft > 0) {
                        if (this.m_QueueSize >= 4) continue block17;
                        int n4 = (int)((double)this.m_JogStepSpeed * this.m_Speed2StepsPerCycletime);
                        if (n4 < 1) {
                            n4 = 1;
                        }
                        if (n4 > this.m_JogStepsLeft) {
                            n4 = this.m_JogStepsLeft;
                        }
                        this.move(this.m_JogForward, n4, this.m_JogStepSpeed);
                        break;
                    }
                    if (this.m_QueueSize != 0) continue block17;
                    this.m_State = State.IDLE;
                    break;
                }
                case JOG_STOPPING: {
                    if (this.m_JogStepsLeft > 0) {
                        this.accelerate(this.m_JogForward, this.m_JogStepSpeed, this.m_JogAcceleration);
                        break;
                    }
                    if (!this.accelerate(this.m_JogForward, 0, this.m_JogAcceleration)) continue block17;
                    this.m_State = State.IDLE;
                }
            }
        } while (state != this.m_State);
    }

    private void move(boolean bl, int n, int n2) {
        this.m_JogStepsLeft = n < this.m_JogStepsLeft ? (this.m_JogStepsLeft -= n) : 0;
        int n3 = this.m_Offset;
        this.m_MessageData[n3 + 0] = 1;
        if (this.FW201) {
            if (bl != this.m_DirPolarity) {
                n = -n;
            }
            this.m_MessageData[n3 + 2] = (byte)n;
            this.m_MessageData[n3 + 3] = (byte)(n >> 8);
        } else {
            this.m_MessageData[n3 + 2] = (byte)(n & 0xFF);
            this.m_MessageData[n3 + 3] = (byte)(bl == this.m_DirPolarity ? 1 : 0);
        }
        this.m_MessageData[n3 + 4] = (byte)(n2 & 0xFF);
        this.m_MessageData[n3 + 5] = (byte)(n2 >> 8 & 0xFF);
    }

    private boolean accelerate(boolean bl, int n, int n2) {
        this.m_CurrentDir = bl;
        int n3 = this.m_CurrentSpeed;
        if (n3 < n) {
            if ((n3 += n2) > n) {
                n3 = n;
            }
        } else if (n3 > n && (n3 -= n2) < n) {
            n3 = n;
        }
        this.m_CurrentSpeed = n3;
        int n4 = (int)((double)n3 * this.m_Speed2StepsPerCycletime);
        this.move(bl, n4, n3);
        return n3 == n;
    }

    void handleHome() {
        block10: do {
            this.state0 = this.m_State;
            if (this.m_QueueSize > 2) {
                return;
            }
            switch (this.m_State) {
                default: {
                    return;
                }
                case HOME_START: {
                    this.m_CurrentSpeed = 0;
                    if (this.m_HomeActive) {
                        this.m_State = State.HOME_ACCEL_OUT_OF_REFSW;
                        break;
                    }
                    this.m_State = State.HOME_ACCEL_TO_REFSW;
                    break;
                }
                case HOME_ACCEL_OUT_OF_REFSW: {
                    if (this.m_HomeActive) {
                        this.accelerate(true, this.m_HomingMaxSpeed, this.m_HomingAcceleration);
                        break;
                    }
                    this.m_State = State.HOME_DECEL_OUT_OF_REFSW;
                    break;
                }
                case HOME_DECEL_OUT_OF_REFSW: {
                    if (!this.accelerate(true, 0, this.m_HomingAcceleration)) continue block10;
                    this.m_State = State.HOME_ACCEL_TO_REFSW;
                    break;
                }
                case HOME_ACCEL_TO_REFSW: {
                    if (!this.m_HomeActive) {
                        this.accelerate(false, this.m_HomingMaxSpeed, this.m_HomingAcceleration);
                        break;
                    }
                    this.m_HomingOvershoot = 0;
                    this.m_State = State.HOME_DECEL_TO_REFSW;
                    break;
                }
                case HOME_DECEL_TO_REFSW: {
                    if (this.accelerate(false, 0, this.m_HomingAcceleration)) {
                        this.m_State = State.HOME_CRAWL_OUT_OF_REFSW;
                    }
                    this.m_HomingOvershoot += (int)((double)this.m_CurrentSpeed * this.m_Speed2StepsPerCycletime);
                    break;
                }
                case HOME_APPROACH_REFSW: {
                    if (this.m_HomingOvershoot > 0) {
                        this.m_CurrentSpeed = this.m_HomingCrawlSpeed;
                        int n = (int)((double)this.m_CurrentSpeed * this.m_Speed2StepsPerCycletime);
                        if (n < 1) {
                            n = 1;
                        }
                        if (n > this.m_HomingOvershoot) {
                            n = this.m_HomingOvershoot;
                        }
                        this.m_HomingOvershoot -= n;
                        this.move(true, n, this.m_CurrentSpeed);
                        break;
                    }
                    this.m_State = State.HOME_CRAWL_OUT_OF_REFSW;
                    break;
                }
                case HOME_CRAWL_OUT_OF_REFSW: {
                    this.m_CurrentSpeed = this.m_HomingCrawlSpeed;
                    if (this.m_HomeActive) {
                        if (this.m_QueueSize > 8) continue block10;
                        this.move(true, 10, this.m_CurrentSpeed);
                        break;
                    }
                    if (this.m_QueueSize != 0) continue block10;
                    this.m_State = State.RESET_POSITION;
                    break;
                }
                case HOME_STOP: {
                    if (!this.accelerate(this.m_CurrentDir, 0, this.m_HomingAcceleration)) continue block10;
                    this.m_State = State.IDLE;
                }
            }
        } while (this.state0 != this.m_State);
    }

    void handleResetPosition() {
        if (this.m_State != State.RESET_POSITION) {
            return;
        }
        if (this.m_SetMotorPositionTo != Integer.MIN_VALUE) {
            int n = this.m_DirPolarity ? this.m_SetMotorPositionTo : -this.m_SetMotorPositionTo;
            int n2 = this.m_Offset;
            this.m_MessageData[n2 + 0] = 2;
            this.m_MessageData[n2 + 4] = (byte)(n & 0xFF);
            this.m_MessageData[n2 + 5] = (byte)(n >> 8 & 0xFF);
            this.m_MessageData[n2 + 6] = (byte)(n >> 16 & 0xFF);
            this.m_MessageData[n2 + 7] = (byte)(n >> 24 & 0xFF);
            if (this.m_Position != this.m_SetMotorPositionTo) {
                return;
            }
        }
        this.m_PositionReset = true;
        this.m_State = State.IDLE;
    }

    private void handleMoves(int n) {
        int n2;
        boolean bl;
        if (this.m_State != State.RUNNING) {
            return;
        }
        int n3 = n - this.m_PlannedMotorPosition;
        if (n3 > 0) {
            bl = true;
            n2 = n3;
        } else {
            bl = false;
            n2 = -n3;
        }
        int n4 = (int)((double)n2 * this.m_StepsPerCycletime2Speed);
        if (n2 > m_MaxTravel) {
            System.err.printf("motor %d move %d > %d [%d => %d]\n", this.m_Motor, m_MaxTravel, this.m_PlannedMotorPosition, n);
            n2 = m_MaxTravel;
        }
        if (n4 > m_MaxVelo) {
            System.err.printf("motor %d velo %d > %d [%d => %d]\n", this.m_Motor, n4, m_MaxVelo, this.m_PlannedMotorPosition, n);
            n4 = m_MaxVelo;
        }
        if (n4 <= 0 && n2 != 0) {
            System.err.printf("motor %d velo %d <= %d [%d => %d]\n", this.m_Motor, n4, 0, this.m_PlannedMotorPosition, n);
            n2 = 0;
            n4 = 0;
        }
        this.move(bl, n2, n4);
        this.m_PlannedMotorPosition += n3;
    }

    private void handleEnableAndGrouping() {
        if (this.m_State != State.IDLE) {
            this.m_Timeout = this.m_TimeOutResetValue;
        }
        byte by = this.m_State == State.RUNNING && this.m_IsMachMotor ? (byte)0 : (byte)this.m_GroupId;
        if (this.m_JogMode != 7) {
            switch (this.m_CurrentMode) {
                case 0: {
                    by = (byte)(by | 0x10);
                    break;
                }
                case 1: {
                    by = (byte)(by | 0x30);
                    break;
                }
                case 2: {
                    if (this.m_Timeout > 0) {
                        by = (byte)(by | 0x30);
                        break;
                    }
                    by = (byte)(by | 0x10);
                    break;
                }
                case 3: {
                    if (this.m_Timeout <= 0) break;
                    by = (byte)(by | 0x30);
                }
            }
        } else {
            this.m_PositionReset = false;
        }
        if (this.m_InvertEnable) {
            by = (byte)(by ^ 0x10);
        }
        this.m_MessageData[this.m_Offset + 1] = by;
    }

    void disableMotor() {
        int n = this.m_Offset + 1;
        this.m_MessageData[n] = (byte)(this.m_MessageData[n] & 0xFFFFFFCF);
        if (this.m_InvertEnable) {
            int n2 = this.m_Offset + 1;
            this.m_MessageData[n2] = (byte)(this.m_MessageData[n2] ^ 0xFFFFFFEF);
        }
    }

    void handleEverything(int n) {
        this.m_MessageData[this.m_Offset] = 0;
        this.handleEnableAndGrouping();
        this.handleMPG();
        this.handleMPGSpeedMode();
        this.handleJog();
        this.handleHome();
        this.handleResetPosition();
        if (n != Integer.MIN_VALUE) {
            this.handleMoves(n);
        }
        if (this.m_Timeout > 0) {
            --this.m_Timeout;
        }
    }

    void updateFromData(byte[] byArray) {
        int n = this.m_Offset;
        int n2 = (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
        this.m_Position = this.m_DirPolarity ? n2 : -n2;
        this.m_QueueCapacity = byArray[n + 4] >> 4 & 0xF;
        this.m_QueueSize = byArray[n + 4] & 0xF;
        this.m_QueueEmpty = this.m_QueueSize == 0;
        this.m_QueueFull = this.m_QueueSize >= this.m_QueueCapacity;
        this.m_HomeInput = (byArray[n + 5] & 1) != 0;
        this.m_HomeActive = (byArray[n + 5] & 1) == this.m_HomePolarity;
    }

    boolean queueFull() {
        return this.m_QueueFull;
    }

    boolean queueEmpty() {
        return this.m_QueueEmpty;
    }

    boolean isMachMotor() {
        return this.m_IsMachMotor;
    }

    int queueSize() {
        return this.m_QueueSize;
    }

    void startRunning() {
        State state = this.m_State;
        if (state != State.IDLE) {
            return;
        }
        this.m_PlannedMotorPosition = this.getPosition();
        this.m_State = State.RUNNING;
    }

    void stopRunning() {
        this.m_PlannedMotorPosition = this.getPosition();
        this.m_State = State.IDLE;
    }

    void abortAll() {
        this.m_State = State.IDLE;
    }

    boolean isHomeInputAsserted() {
        return this.m_HomeActive;
    }

    boolean getHomeInput() {
        return this.m_HomeInput;
    }

    public void unsetPosition() {
        this.m_PositionReset = false;
    }

    private void handleMPGSpeedMode() {
        boolean bl;
        if (this.m_State != State.MPG_MODE_SPEED) {
            return;
        }
        if (this.queueSize() >= 2) {
            return;
        }
        boolean bl2 = bl = this.m_MpgTargetSpeed > 0;
        if (bl != this.m_CurrentDir && this.m_CurrentSpeed != 0) {
            this.accelerate(this.m_CurrentDir, 0, this.m_JogAcceleration);
        } else {
            this.accelerate(bl, Math.abs(this.m_MpgTargetSpeed), this.m_JogAcceleration);
        }
    }

    private void handleMPG() {
        int n;
        if (this.m_State != State.MPG_MODE) {
            return;
        }
        if (this.queueSize() >= 2) {
            return;
        }
        int n2 = this.m_MpgTargetPosition - this.m_MpgPosition;
        if (n2 == 0 && this.m_MpgSpeed == 0) {
            this.m_MpgDir = 0;
            this.m_MpgSpeed = 0;
            this.m_State = State.IDLE;
            return;
        }
        double d = (double)this.m_MpgSpeed * this.m_Cycletime / (double)this.m_JogAcceleration;
        double d2 = (double)this.m_JogAcceleration * this.m_Speed2StepsPerCycletime / (this.m_Cycletime * this.m_Cycletime);
        int n3 = (int)(0.5 * d2 * (d += this.m_Cycletime * 2.0) * d);
        if (this.m_MpgDir > 0 && n2 < 0 || this.m_MpgDir < 0 && n2 > 0) {
            n2 = 0;
        }
        if (this.m_MpgSpeed == 0) {
            if (n2 < 0) {
                this.m_MpgDir = -1;
            }
            if (n2 > 0) {
                this.m_MpgDir = 1;
            }
        }
        int n4 = n = n2 < 0 ? -n2 : n2;
        if (n2 != 0) {
            if (n > n3) {
                this.m_MpgSpeed += this.m_JogAcceleration;
                if (this.m_MpgSpeed > this.m_MpgTargetSpeed) {
                    this.m_MpgSpeed = this.m_MpgTargetSpeed;
                }
            } else {
                this.m_MpgSpeed -= this.m_JogAcceleration;
                if (this.m_MpgSpeed <= this.m_JogSlowSpeed) {
                    this.m_MpgSpeed = this.m_JogSlowSpeed;
                }
            }
        } else {
            this.m_MpgSpeed -= this.m_JogAcceleration;
            if (this.m_MpgSpeed <= 0) {
                this.m_MpgSpeed = 0;
                this.m_MpgDir = 0;
            }
        }
        if (this.m_MpgSpeed > 0) {
            int n5 = (int)((double)this.m_MpgSpeed / this.m_StepsPerCycletime2Speed);
            if (n5 < 1) {
                n5 = 1;
            }
            int n6 = n > n5 ? n5 : n;
            this.move(this.m_MpgDir > 0, n6, this.m_MpgSpeed);
            this.m_MpgPosition = this.m_MpgDir > 0 ? (this.m_MpgPosition += n6) : (this.m_MpgPosition -= n6);
        }
    }

    void setMpgTarget(int n, int n2) {
        if (!this.m_IsMachMotor) {
            return;
        }
        if (this.m_State != State.IDLE && this.m_State != State.MPG_MODE) {
            return;
        }
        if (this.m_LimitsEnable && (n < this.m_LimitPositionMin || n > this.m_LimitPositionMax)) {
            return;
        }
        if (this.m_State == State.IDLE) {
            this.m_MpgPosition = this.m_Position;
            this.m_MpgSpeed = 0;
            this.m_MpgDir = 0;
        }
        this.m_MpgTargetSpeed = n2;
        if (this.m_MpgTargetSpeed == Integer.MAX_VALUE) {
            this.m_MpgTargetSpeed = this.m_JogFastSpeed;
        }
        this.m_MpgTargetPosition = n;
        this.m_State = State.MPG_MODE;
    }

    void setMpgTargetSpeed(int n) {
        if (!this.m_IsMachMotor) {
            return;
        }
        if (this.m_State != State.IDLE && this.m_State != State.MPG_MODE_SPEED) {
            return;
        }
        if (this.m_State == State.IDLE) {
            this.m_MpgPosition = this.m_Position;
            this.m_MpgSpeed = 0;
            this.m_MpgDir = 0;
        }
        this.m_MpgTargetSpeed = n;
        this.m_State = State.MPG_MODE_SPEED;
    }

    boolean isInMpgMode() {
        return this.m_State == State.MPG_MODE;
    }

    boolean isIdle() {
        return this.m_State == State.IDLE;
    }

    static enum State {
        IDLE,
        RUNNING,
        JOG_START,
        JOG_FAST,
        JOG_SLOW,
        JOG_STEP,
        JOG_DECELEREATE_TO_LIMIT,
        JOG_CRAWL_TO_LIMIT,
        JOG_STOPPING,
        HOME_START,
        HOME_ACCEL_OUT_OF_REFSW,
        HOME_DECEL_OUT_OF_REFSW,
        HOME_ACCEL_TO_REFSW,
        HOME_DECEL_TO_REFSW,
        HOME_APPROACH_REFSW,
        HOME_CRAWL_OUT_OF_REFSW,
        HOME_STOP,
        RESET_POSITION,
        MPG_MODE,
        MPG_MODE_SPEED;

    }
}

