/*
 * Decompiled with CFR 0.152.
 */
package toad4plus;

import com.eazycnc.motorcontroller.MotorController;
import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.Observer;
import eazycnc.Main;
import eazycnc.PluginMethods;
import eazycnc.ToadCommLogger;
import eazycnc.gcode.MachState;
import eazycnc.gcode.Machcode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import toad4plus.Toad4PlusMotor;
import toad4plus.simulator.Toad4PlusSimulator2;

public class Toad4PlusMotorController
implements MotorController {
    final boolean FW201 = true;
    private ToadCommLogger m_ToadCommLogger;
    private byte[] m_Running = new byte[16];
    private volatile byte[] m_MessageData = new byte[64];
    private volatile boolean m_TestModeEnabled = false;
    private volatile double m_NCOSize = 65536.0;
    private volatile double m_NCOFreq = 100000.0;
    private volatile ToadPlusCommInterface m_ToadPlusComm;
    private volatile ToadPlusCommInterface m_ToadPlusActualDevice;
    private volatile ToadPlusCommInterface m_ToadPlusSimulatedDevice;
    private volatile ConnectionState m_RequesteConnectionState = ConnectionState.SHUTDOWN;
    private volatile ConnectionState m_ConnectionState = ConnectionState.SHUTDOWN;
    private volatile Thread m_RealTimeThread;
    private volatile int m_NumberOfMotors;
    private volatile String m_VersionString = null;
    private volatile int m_VersionMajor;
    private volatile int m_VersionMinor;
    private volatile int m_VersionBuxFix;
    private volatile boolean m_MachMotorQueuesFull = false;
    private volatile boolean m_MachMotorQueuesEmpty = true;
    public volatile Toad4PlusMotor[] m_Motors;
    private volatile boolean m_ProbePolarity = true;
    private volatile boolean m_ProbeInput;
    private volatile boolean m_InManualMode;
    private volatile boolean m_ArcTransferInput;
    private volatile boolean m_ProbeAsserted;
    private volatile boolean m_ProbeArmed;
    private volatile boolean m_ProbeTriggered;
    private volatile int[] m_ProbePosition;
    private volatile Queue<int[]> m_MoveQueue = new ArrayDeque<int[]>(1);
    Object m_MessageReceivedSema4 = new Object();
    private volatile long m_NanoTime0;
    private volatile byte m_DigitalOutputs;
    private volatile byte m_AnalogOutput;
    private volatile int m_AnalogInput;
    public volatile Toad4PlusSimulator2 m_Simulator;
    private volatile int[] m_Motor2Axis;
    private static boolean m_TestWatchdog;
    private boolean m_IsRunning;
    BufferedWriter m_DebugWriter;
    volatile String m_DebugMachcode;
    private int[] m_TestPhase;
    private int[] m_TestCounter;
    long t0;
    public static int[] m_DebugPostion;
    boolean m_GotConfig = false;
    int testCnt = 0;
    int[] pos = new int[4];
    long m_t0;

    public Toad4PlusMotorController(int n, ToadPlusCommInterface toadPlusCommInterface, MachState machState, PluginMethods pluginMethods, ToadCommLogger toadCommLogger) {
        int n2;
        this.m_ToadCommLogger = toadCommLogger;
        this.m_NumberOfMotors = n;
        this.m_Simulator = new Toad4PlusSimulator2(machState);
        this.m_Motors = new Toad4PlusMotor[this.m_NumberOfMotors];
        for (n2 = 0; n2 < this.m_NumberOfMotors; ++n2) {
            this.m_Motors[n2] = new Toad4PlusMotor(this, this.m_Simulator, machState, n2, this.m_MessageData, this.getMaxVelo(), this.getMaxTravel());
        }
        n2 = 0;
        while (n2 < 6) {
            int n3 = n2++;
            Observer observer = observable -> {
                int n2 = machState.getParamInt(-2147483638, n3);
                int n3 = machState.getParamInt(-2147483637, n3);
                if (n2 >= 0) {
                    this.m_Motors[n2].assignAxis(n3, n2, n3);
                }
                if (n3 >= 0) {
                    this.m_Motors[n3].assignAxis(n3, n2, -1);
                }
            };
            machState.getVariable(-2147483638, n3).addObserver(observer);
            machState.getVariable(-2147483637, n3).addObserver(observer);
            machState.getVariable(15176).addObserver(observable -> {
                this.m_ProbePolarity = machState.getParamBoolean(15176);
            });
        }
        this.m_RealTimeThread = new Thread(() -> this.runOnBackground(), "ToadPlusMotorController");
        this.m_RealTimeThread.setPriority(10);
        this.m_RealTimeThread.setUncaughtExceptionHandler((thread, throwable) -> {
            System.err.println("class ToadPlusMotorController: uncaught exception");
            throwable.printStackTrace();
        });
        this.m_ToadPlusActualDevice = toadPlusCommInterface;
        this.m_ToadPlusSimulatedDevice = this.m_Simulator;
        this.m_ToadPlusComm = null;
        this.m_NanoTime0 = System.nanoTime();
        this.m_RealTimeThread.start();
    }

    public void setDebugMachcode(Machcode machcode) {
        this.m_DebugMachcode = machcode == null ? "null" : machcode.toString();
    }

    private void openDebugLog() {
    }

    private void closeDebugLog() {
        if (this.m_DebugWriter == null) {
            return;
        }
        try {
            System.out.println("closing debug log");
            this.m_DebugWriter.close();
            this.m_DebugWriter = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeDebugLog(byte[] byArray) {
        if (this.m_DebugWriter == null) {
            return;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("|");
            if (byArray != null) {
                for (int i = 0; i < 64; ++i) {
                    stringBuffer.append(String.format("%02X", byArray[i]));
                }
            } else {
                stringBuffer.append("null");
            }
            this.m_DebugWriter.write(stringBuffer.toString());
            this.m_DebugWriter.flush();
        }
        catch (Exception exception) {
            System.err.println("debug log write exception " + exception.getClass().getSimpleName() + " " + exception.getMessage());
        }
    }

    private void debugLogNewLine(boolean bl, boolean bl2) {
        if (this.m_DebugWriter == null) {
            return;
        }
        try {
            this.m_DebugWriter.write(String.format("%016X|%c%c", System.currentTimeMillis(), Character.valueOf(bl ? (char)'F' : '-'), Character.valueOf(bl ? (char)'N' : '-')));
        }
        catch (Exception exception) {
            System.err.println("debug log write exception " + exception.getClass().getSimpleName() + " " + exception.getMessage());
        }
    }

    private void debugLogEndLine() {
        if (this.m_DebugWriter == null) {
            return;
        }
        try {
            this.m_DebugWriter.write("\n");
            this.m_DebugWriter.flush();
        }
        catch (Exception exception) {
            System.err.println("debug log write exception " + exception.getClass().getSimpleName() + " " + exception.getMessage());
        }
    }

    @Override
    public String getVersion() {
        return this.m_VersionString;
    }

    @Override
    public ConnectionState getConnectionState() {
        if (this.m_ConnectionState == ConnectionState.CONNECTED && !this.m_GotConfig) {
            return ConnectionState.CONTROLLER_FOUND;
        }
        return this.m_ConnectionState;
    }

    private void closeSimulatedDevice() {
        if (this.m_ToadPlusComm == this.m_ToadPlusSimulatedDevice) {
            this.m_ToadPlusComm.tryToCloseDevice();
            this.m_ToadPlusComm = null;
            this.m_GotConfig = false;
            this.m_VersionString = null;
        }
    }

    private void closeActualDevice() {
        if (this.m_ToadPlusComm == this.m_ToadPlusActualDevice) {
            this.m_ToadPlusComm.tryToCloseDevice();
            this.m_ToadPlusComm = null;
            this.m_GotConfig = false;
            this.m_VersionString = null;
        }
    }

    @Override
    public void setConnectionState(ConnectionState connectionState) {
        this.m_RequesteConnectionState = connectionState;
    }

    private void turnOffMotorCurrents() {
        try {
            for (int i = 0; i < this.m_NumberOfMotors; ++i) {
                if (!this.m_Motors[i].isMachMotor()) continue;
                this.m_Motors[i].disableMotor();
                int n = this.m_Motors[i].getSlave();
                if (n < 0 || this.m_Motors[i].isHoming() || this.m_Motors[n].isHoming()) continue;
                System.arraycopy(this.m_MessageData, i * 8, this.m_MessageData, n * 8, 8);
            }
            if (this.m_ToadPlusComm != null) {
                this.m_ToadPlusComm.sendMessage(this.m_MessageData);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void tryToSetConnectionState() {
        if (this.m_RequesteConnectionState == ConnectionState.CONNECTED) {
            this.closeSimulatedDevice();
            Main.m_ToadCommLogger.stopLogging();
            this.m_ConnectionState = this.m_ToadPlusActualDevice.tryToOpenDevice();
            if (this.m_ConnectionState == ConnectionState.CONNECTED) {
                this.m_ToadPlusComm = this.m_ToadPlusActualDevice;
            }
        } else if (this.m_RequesteConnectionState == ConnectionState.SIMULATION) {
            this.closeActualDevice();
            Main.m_ToadCommLogger.stopLogging();
            this.m_ConnectionState = this.m_ToadPlusSimulatedDevice.tryToOpenDevice();
            if (this.m_ConnectionState == ConnectionState.SIMULATION) {
                this.m_ToadPlusComm = this.m_ToadPlusSimulatedDevice;
            }
        } else if (this.m_RequesteConnectionState == ConnectionState.SHUTDOWN) {
            this.turnOffMotorCurrents();
            this.closeSimulatedDevice();
            this.closeActualDevice();
            Main.m_ToadCommLogger.stopLogging();
            this.m_ConnectionState = ConnectionState.SHUTDOWN;
        } else {
            throw new IllegalArgumentException("Bad request " + this.m_RequesteConnectionState);
        }
        if (this.m_ConnectionState == ConnectionState.CONNECTED) {
            this.openDebugLog();
        } else {
            this.closeDebugLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueMove(int[] nArray) throws Exception {
        if (this.m_ConnectionState != ConnectionState.CONNECTED && this.m_ConnectionState != ConnectionState.SIMULATION) {
            this.throwNotConnected();
        }
        Queue<int[]> queue = this.m_MoveQueue;
        synchronized (queue) {
            while (this.m_MoveQueue.size() >= 16) {
                this.m_MoveQueue.wait(100L);
            }
            this.m_MoveQueue.add(nArray);
            this.m_MoveQueue.notifyAll();
        }
    }

    @Override
    public boolean startJogging(int n, boolean bl) throws Exception {
        return this.m_Motors[n].startJogging(bl);
    }

    @Override
    public void stopJogging(int n) throws Exception {
        this.m_Motors[n].stopJogging();
    }

    @Override
    public void startHoming(int n, int n2) {
        this.m_Motors[n].startHoming(n2);
        int n3 = this.m_Motors[n].getSlave();
        if (n3 >= 0) {
            this.m_Motors[n3].startHoming(n2);
        }
    }

    @Override
    public void stopHoming(int n) {
        this.m_Motors[n].stopHoming();
        int n2 = this.m_Motors[n].getSlave();
        if (n2 >= 0) {
            this.m_Motors[n2].stopHoming();
        }
    }

    @Override
    public boolean isPositionReset(int n) {
        if (!this.m_Motors[n].isPositionReset()) {
            return false;
        }
        int n2 = this.m_Motors[n].getSlave();
        if (n2 >= 0) {
            return this.m_Motors[n2].isPositionReset();
        }
        return true;
    }

    @Override
    public void abortAll() {
        for (int i = 0; i < this.m_NumberOfMotors; ++i) {
            this.m_Motors[i].abortAll();
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        this.m_Motors[n].setPosition(n2);
    }

    @Override
    public int[] getMotorPosition() {
        int[] nArray = new int[this.m_NumberOfMotors];
        for (int i = 0; i < this.m_NumberOfMotors; ++i) {
            nArray[i] = this.m_Motors[i].getPosition();
        }
        return nArray;
    }

    @Override
    public void armProbe(boolean bl) {
        this.m_ProbeArmed = bl;
    }

    @Override
    public int[] getProbePosition() {
        return this.m_ProbePosition;
    }

    @Override
    public double getVelocityFactor() {
        return this.m_NCOSize / this.m_NCOFreq;
    }

    @Override
    public MotorController.MotorState getMotorState(int n) {
        if (this.m_ConnectionState != ConnectionState.CONNECTED && this.m_ConnectionState != ConnectionState.SIMULATION) {
            return MotorController.MotorState.OFFLINE;
        }
        return this.m_Motors[n].getMotorState();
    }

    @Override
    public void emergencyStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws InterruptedException {
        for (int i = 0; i < 2; ++i) {
            Object object = this.m_MessageReceivedSema4;
            synchronized (object) {
                do {
                    this.m_MessageReceivedSema4.wait(200L);
                } while (!this.m_MachMotorQueuesEmpty);
                continue;
            }
        }
    }

    @Override
    public void setPairXA(boolean bl) {
    }

    private void measureCpuUtilisation() {
    }

    private void testMode(byte[] byArray) throws InterruptedException, IOException {
        if (this.m_TestPhase == null) {
            this.m_TestPhase = new int[this.m_NumberOfMotors];
            this.m_TestCounter = new int[this.m_NumberOfMotors];
        }
        for (int i = 0; i < this.m_NumberOfMotors; ++i) {
            int n = i * 8;
            int n2 = 0;
            byArray[n + 1] = 1;
            switch (this.m_TestPhase[i]) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 20;
                    break;
                }
                case 2: {
                    n2 = 0;
                    break;
                }
                case 3: {
                    n2 = -20;
                }
            }
            if (n2 != 0) {
                int n3 = n + 1;
                byArray[n3] = (byte)(byArray[n3] | 0x30);
            }
            if (this.m_Motors[i].queueSize() >= 7) continue;
            int n4 = i;
            this.m_TestCounter[n4] = this.m_TestCounter[n4] - 1;
            if (this.m_TestCounter[n4] < 0) {
                this.m_TestCounter[i] = 10;
                this.m_TestPhase[i] = (this.m_TestPhase[i] + 1) % 4;
                System.out.println("motor " + i + " test phase " + this.m_TestPhase[i]);
            }
            int n5 = (int)((double)Math.abs(n2) * this.getVelocityFactor() * 100.0);
            byArray[n + 0] = 1;
            byArray[n + 2] = (byte)n2;
            byArray[n + 3] = (byte)(n2 >> 8);
            byArray[n + 4] = (byte)(n5 & 0xFF);
            byArray[n + 5] = (byte)(n5 >> 8 & 0xFF);
        }
    }

    private void getToad4PlusConfig() throws IOException, InterruptedException {
        byte[] byArray = new byte[64];
        byArray[0] = -2;
        byArray[1] = 1;
        byte[] byArray2 = this.m_ToadPlusComm.sendMessage(byArray);
        this.m_VersionMajor = byArray2[0] & 0xFF;
        this.m_VersionMinor = byArray2[1] & 0xFF;
        this.m_VersionBuxFix = byArray2[2] & 0xFF;
        this.m_NumberOfMotors = byArray2[3] & 0xFF;
        this.m_NCOFreq = (byArray2[4] & 0xFF) + ((byArray2[5] & 0xFF) << 8) + ((byArray2[6] & 0xFF) << 16) + ((byArray2[7] & 0xFF) << 24);
        this.m_VersionString = String.format("%d.%d.%d-%d", this.m_VersionMajor, this.m_VersionMinor, this.m_VersionBuxFix, this.m_NumberOfMotors);
        if ((byArray2[62] & 8) == 0) {
            this.m_VersionString = this.m_VersionString + " (Wathdog reset detected)";
        }
        if (this.m_VersionMajor == 0) {
            System.out.println("Error, TOAD4 firmware major version number is 0");
        } else {
            this.m_GotConfig = true;
        }
        for (int i = 0; i < this.m_NumberOfMotors; ++i) {
            if (!this.m_Motors[i].isMachMotor()) continue;
            this.m_Motors[i].unsetPosition();
            byArray[i * 8] = 3;
        }
        this.m_ToadPlusComm.sendMessage(byArray);
    }

    private void logMoves() {
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < 4; ++i) {
            int n = i * 8;
            if (this.m_MessageData[n] != 1) continue;
            if (bl) {
                System.out.printf("CMD_MOVE ", new Object[0]);
            }
            bl = false;
            bl2 = true;
            int n2 = this.m_MessageData[n + 2] & 0xFF | this.m_MessageData[n + 3] << 8;
            int n3 = this.m_MessageData[n + 4] & 0xFF | this.m_MessageData[n + 5] << 8;
            String string = String.format("\u2206%c: %d  v: %d   ", Character.valueOf("XYZABC".charAt(i)), n2, n3);
            System.out.printf(string, new Object[0]);
        }
        if (bl2) {
            System.out.println();
        }
    }

    int[] nextTestPosition() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.testCnt % 25;
        switch (this.testCnt / 25 % 4) {
            case 0: {
                this.pos[0] = n * 800;
                break;
            }
            case 1: {
                this.pos[1] = n * 800;
                break;
            }
            case 2: {
                this.pos[0] = (24 - n) * 800;
                break;
            }
            case 3: {
                this.pos[1] = (24 - n) * 800;
            }
        }
        ++this.testCnt;
        return this.pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runOnBackground() {
        block7: while (true) {
            try {
                while (true) {
                    if (this.m_RequesteConnectionState != this.m_ConnectionState) {
                        this.tryToSetConnectionState();
                        if (this.m_RequesteConnectionState == this.m_ConnectionState) continue;
                        Thread.sleep(500L);
                        continue;
                    }
                    if (this.m_ToadPlusComm == null) {
                        Thread.sleep(100L);
                        continue;
                    }
                    try {
                        int n;
                        int n2;
                        int n3;
                        Object object;
                        if (!this.m_GotConfig) {
                            this.getToad4PlusConfig();
                            continue block7;
                        }
                        int[] nArray = null;
                        if (!this.m_MachMotorQueuesFull) {
                            object = this.m_MoveQueue;
                            synchronized (object) {
                                nArray = this.m_MoveQueue.poll();
                                m_DebugPostion = nArray;
                            }
                        }
                        for (n3 = 0; n3 < this.m_NumberOfMotors; ++n3) {
                            n2 = Integer.MIN_VALUE;
                            if (nArray != null && (n = this.m_Motors[n3].getMaster()) >= 0) {
                                n2 = nArray[n];
                            }
                            this.m_Motors[n3].handleEverything(n2);
                        }
                        for (n3 = 0; n3 < this.m_NumberOfMotors; ++n3) {
                            n2 = n3;
                            n = this.m_Motors[n2].getSlave();
                            if (n < 0 || this.m_Motors[n2].isHoming() || this.m_Motors[n].isHoming()) continue;
                            System.arraycopy(this.m_MessageData, n2 * 8, this.m_MessageData, n * 8, 8);
                        }
                        this.m_MessageData[50] = this.m_DigitalOutputs;
                        this.m_MessageData[52] = this.m_AnalogOutput;
                        this.m_MessageData[49] = this.m_ProbeArmed ? (this.m_ProbePolarity ? 1 : 2) : 0;
                        if (this.m_TestModeEnabled) {
                            this.testMode(this.m_MessageData);
                        }
                        this.debugLogNewLine(this.m_MachMotorQueuesFull, nArray != null);
                        this.m_ToadCommLogger.logMessage(this.m_Running, this.m_MessageData);
                        if (m_TestWatchdog) {
                            m_TestWatchdog = false;
                            this.m_MessageData[0] = 115;
                        }
                        object = this.m_ToadPlusComm.sendMessage(this.m_MessageData);
                        n2 = object[60] & 0xF;
                        n = object[61] & 0xF;
                        int n4 = object[62] & 0xF;
                        this.m_ToadCommLogger.logResponse((byte[])object);
                        this.debugLogEndLine();
                        this.handleResponse((byte[])object);
                        Thread.sleep(4L);
                        long l = System.nanoTime();
                        if (this.m_t0 == 0L) continue block7;
                        long l2 = l - this.m_t0;
                        this.m_t0 = 0L;
                        if (l2 <= 100000000L) continue block7;
                        System.out.println("dt = " + l2);
                        continue block7;
                    }
                    catch (Exception exception) {
                        this.tryToCloseDevice();
                        Thread.sleep(5000L);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        byte[] byArray2 = byArray;
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < this.m_NumberOfMotors) {
            this.m_Motors[n2].updateFromData(byArray);
            if (this.m_Motors[n2].isMachMotor()) {
                if (this.m_Motors[n2].queueFull()) {
                    bl = true;
                }
                if (!this.m_Motors[n2].queueEmpty()) {
                    bl2 = false;
                }
            }
            ++n2;
            n += 8;
        }
        this.m_MachMotorQueuesEmpty = bl2;
        this.m_MachMotorQueuesFull = bl;
        this.m_ProbeInput = (byArray[49] & 1) != 0;
        this.m_ProbeAsserted = this.m_ProbeInput == this.m_ProbePolarity;
        this.m_AnalogInput = byArray[52] & 0xFF;
        this.m_InManualMode = byArray[53] != 0;
        this.m_ArcTransferInput = (byArray[50] & 1) != 0;
        boolean bl3 = this.m_ProbeTriggered = (byArray[49] & 2) != 0;
        if (this.m_ProbeTriggered) {
            int[] nArray = new int[this.m_NumberOfMotors];
            for (int i = 0; i < this.m_NumberOfMotors; ++i) {
                nArray[i] = this.m_Motors[i].getPosition();
            }
            this.m_ProbePosition = nArray;
        }
        Object object = this.m_MessageReceivedSema4;
        synchronized (object) {
            this.m_MessageReceivedSema4.notifyAll();
        }
    }

    private void tryToCloseDevice() {
        this.m_GotConfig = false;
        this.m_VersionString = null;
        this.m_ConnectionState = this.m_ToadPlusComm.tryToCloseDevice();
    }

    private void throwNotConnected() throws Exception {
        throw new IllegalArgumentException("Motor controller not connected");
    }

    @Override
    public int getNumberOfMotors() {
        return 5;
    }

    @Override
    public boolean getProbeTriggered() {
        return this.m_ProbeTriggered;
    }

    @Override
    public void startRunning() {
        this.m_IsRunning = true;
        this.m_Running[0] = 1;
        for (int i = 0; i < this.m_NumberOfMotors; ++i) {
            if (!this.m_Motors[i].isMachMotor()) continue;
            this.m_Motors[i].startRunning();
            int n = this.m_Motors[i].getSlave();
            if (n < 0) continue;
            this.m_Motors[n].startRunning();
        }
    }

    @Override
    public void stopRunning() {
        this.m_IsRunning = false;
        for (int i = 0; i < this.m_NumberOfMotors; ++i) {
            if (!this.m_Motors[i].isMachMotor()) continue;
            this.m_Motors[i].stopRunning();
            int n = this.m_Motors[i].getSlave();
            if (n < 0) continue;
            this.m_Motors[n].stopRunning();
        }
        this.m_Running[0] = 0;
    }

    public static void test() {
        int n;
        int n2;
        int n3 = 10000;
        int n4 = 100000;
        int[] nArray = new int[n3];
        double[] dArray = new double[n3];
        Random random = new Random(1L);
        for (int i = 0; i < n3; ++i) {
            nArray[i] = random.nextInt();
            dArray[i] = random.nextDouble();
        }
        long l = System.currentTimeMillis();
        for (n2 = 1; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                int n5 = n2;
                nArray[n5] = nArray[n5] - nArray[n2 - 1];
            }
        }
        System.out.println(String.format("time needed for int subs [ms]: %s", System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n2 = 1; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                int n6 = n2;
                dArray[n6] = dArray[n6] - dArray[n2 - 1];
            }
        }
        System.out.println(String.format("time needed for dbl subs [ms]: %s", System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n2 = 1; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                int n7 = n2;
                nArray[n7] = nArray[n7] * nArray[n2 - 1];
            }
        }
        System.out.println(String.format("time needed for int mult [ms]: %s", System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n2 = 1; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                int n8 = n2;
                dArray[n8] = dArray[n8] * dArray[n2 - 1];
            }
        }
        System.out.println(String.format("time needed for dbl mult [ms]: %s", System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n2 = 1; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                nArray[n2] = nArray[n2 - 1];
            }
        }
        System.out.println(String.format("time needed for int asgn [ms]: %s", System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        for (n2 = 1; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                dArray[n2] = dArray[n2 - 1];
            }
        }
        System.out.println(String.format("time needed for dbl asgn [ms]: %s", System.currentTimeMillis() - l));
    }

    public static void mainx(String ... stringArray) {
        for (int i = 0; i < 1000; ++i) {
            Toad4PlusMotorController.test();
        }
    }

    @Override
    public boolean getProbeInputAsserted() {
        return this.m_ProbeAsserted;
    }

    @Override
    public boolean getHomeInputAsserted(int n) {
        return this.m_Motors[n].isHomeInputAsserted();
    }

    @Override
    public boolean getProbeInput() {
        return this.m_ProbeInput;
    }

    @Override
    public boolean getArcTransferInput() {
        return this.m_ArcTransferInput;
    }

    @Override
    public boolean getHomeInput(int n) {
        return this.m_Motors[n].getHomeInput();
    }

    @Override
    public boolean getIsControllerInManualMode() {
        return this.m_InManualMode;
    }

    @Override
    public boolean isHoming(int n) {
        if (this.m_Motors[n].isHoming()) {
            return true;
        }
        int n2 = this.m_Motors[n].getSlave();
        if (n2 >= 0) {
            return this.m_Motors[n2].isHoming();
        }
        return false;
    }

    @Override
    public boolean getDigitalInput(int n) {
        return false;
    }

    @Override
    public void setDigitalOutput(int n, boolean bl) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("no such output: " + n);
        }
        int n2 = 1 << n;
        this.m_DigitalOutputs = bl ? (byte)(this.m_DigitalOutputs | n2) : (byte)(this.m_DigitalOutputs & ~n2);
    }

    @Override
    public int getAnalogInput(int n) {
        switch (n) {
            case 0: {
                return this.m_AnalogInput;
            }
        }
        throw new IllegalArgumentException("no such input: " + n);
    }

    @Override
    public void setAnalogOutput(int n, int n2) {
        switch (n) {
            case 0: {
                this.m_AnalogOutput = (byte)n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("no such output: " + n);
            }
        }
    }

    @Override
    public boolean getDigitalOutput(int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("no such output: " + n);
        }
        int n2 = 1 << n;
        return (this.m_DigitalOutputs & n2) != 0;
    }

    @Override
    public int getAnalogOutput(int n) {
        switch (n) {
            case 0: {
                return this.m_AnalogOutput & 0xFF;
            }
        }
        throw new IllegalArgumentException("no such output: " + n);
    }

    @Override
    public int getMaxVelo() {
        return 8192;
    }

    @Override
    public int getMaxTravel() {
        return Short.MAX_VALUE;
    }

    public void testWatchdog() {
        m_TestWatchdog = true;
    }

    @Override
    public void setMpgTarget(int n, int n2, int n3) {
        this.m_Motors[n].setMpgTarget(n2, n3);
    }

    @Override
    public boolean isInMpgMode(int n) {
        return this.m_Motors[n].isInMpgMode();
    }

    @Override
    public void setMpgTargetSpeed(int n, int n2) {
        this.m_Motors[n].setMpgTargetSpeed(n2);
    }

    @Override
    public boolean isIdle(int n) {
        return this.m_Motors[n].isIdle();
    }

    @Override
    public void setTestMode(boolean bl) {
        this.m_TestModeEnabled = bl;
    }

    static {
        m_DebugPostion = new int[4];
    }

    public static interface ToadPlusCommInterface {
        public ConnectionState tryToOpenDevice();

        public ConnectionState tryToCloseDevice();

        public byte[] sendMessage(byte[] var1) throws IOException, InterruptedException;

        public boolean getAccessDenied();
    }
}

