/*
 * Decompiled with CFR 0.152.
 */
package toad4plus.simulator;

import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.Observer;
import eazycnc.gcode.MachState;
import toad4plus.Toad4PlusMotorController;
import toad4plus.simulator.probe.ProbeSimulator;

public class Toad4PlusSimulator2
implements Toad4PlusMotorController.ToadPlusCommInterface {
    static final int CMD_MOVE = 1;
    static final int CMD_RESET_POSITION = 2;
    static final int CMD_REINIT_MOTOR = 3;
    static final int CMD_RESET_MOTOR = 4;
    private static int NCO_FREQ = 100000;
    int m_NumberOfMotors = 4;
    StepperState[] m_StepperState;
    byte[] m_DataIn = new byte[64];
    long m_SimuStartTime = 0L;
    int m_NCOInterruptCount = 0;
    long m_LastTime;
    volatile boolean m_SWI;
    boolean m_ProbePolarity;
    int m_TotalX;
    public ProbeSimulatorInterface m_ProbeSimulator;
    boolean m_ProbeActive;
    boolean m_ProbeTrigOn1;
    boolean m_ProbeTrigOn0;
    boolean m_ProbeTriggered;
    int[] m_DebugOldPos = new int[6];
    int m_DebugCount = 0;
    int[] min = new int[]{999999, 999999};
    int[] max = new int[]{-999999, -999999};

    public void setProbePolarity(boolean bl) {
        this.m_ProbePolarity = bl;
    }

    public Toad4PlusSimulator2(MachState machState) {
        this.m_StepperState = new StepperState[this.m_NumberOfMotors];
        for (int i = 0; i < this.m_NumberOfMotors; ++i) {
            this.m_StepperState[i] = new StepperState(this, machState, i);
        }
        this.m_ProbeSimulator = new ProbeSimulator();
    }

    void runSimulation() {
        try {
            int n;
            int n2;
            int n3;
            long l = System.nanoTime();
            int n4 = (int)((double)(l - this.m_SimuStartTime) * 1.0E-9 * (double)NCO_FREQ);
            int n5 = n4 - this.m_NCOInterruptCount;
            this.m_NCOInterruptCount = n4;
            this.m_LastTime = l;
            for (n2 = n5; n2 > 0; n2 -= n3) {
                int n6;
                n = 0;
                int n7 = 0;
                for (n6 = 0; n6 < this.m_NumberOfMotors; ++n6) {
                    if (this.m_StepperState[n6].m_Busy) {
                        n |= 1 << n6;
                    }
                    if (!this.m_StepperState[n6].m_Ready) continue;
                    n7 |= 1 << n6;
                }
                n3 = Integer.MAX_VALUE;
                for (n6 = 0; n6 < this.m_NumberOfMotors; ++n6) {
                    int n8 = this.m_StepperState[n6].m_Speed;
                    int n9 = Integer.MAX_VALUE;
                    if (n8 > 0) {
                        n9 = (65536 - this.m_StepperState[n6].m_Nco) / n8;
                    }
                    if (n9 >= n3) continue;
                    n3 = n9;
                }
                if (n3 < 1) {
                    n3 = 1;
                }
                if (n3 > n5) {
                    n3 = n5;
                }
                for (n6 = 0; n6 < this.m_NumberOfMotors; ++n6) {
                    this.m_StepperState[n6].doNcoInterruptProcessing(n3, n, n7);
                }
                while (this.m_SWI) {
                    this.m_SWI = false;
                    for (n6 = 0; n6 < this.m_NumberOfMotors; ++n6) {
                        this.m_StepperState[n6].updatePos(this);
                    }
                    for (n6 = 0; n6 < this.m_NumberOfMotors; ++n6) {
                        this.m_StepperState[n6].feedMore(this);
                    }
                }
            }
            n2 = 0;
            for (n = 0; n < 2; ++n) {
                if (this.m_StepperState[n].m_StepCount < this.min[n]) {
                    this.min[n] = this.m_StepperState[n].m_StepCount;
                    n2 = 1;
                }
                if (this.m_StepperState[n].m_StepCount <= this.max[n]) continue;
                this.max[n] = this.m_StepperState[n].m_StepCount;
                n2 = 1;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public ConnectionState tryToOpenDevice() {
        System.out.println("SIMULATION STARTED");
        this.m_SimuStartTime = System.nanoTime();
        this.m_NCOInterruptCount = 0;
        return ConnectionState.SIMULATION;
    }

    @Override
    public ConnectionState tryToCloseDevice() {
        System.out.println("SIMULATION STOPPED");
        return ConnectionState.SHUTDOWN;
    }

    void dumpCommands(byte[] byArray) {
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            byte by = byArray[i * 8 + 0];
            int n = byArray[i * 8 + 1] & 0xF;
            if (by != 1) continue;
            short s = Toad4PlusSimulator2.getShort(byArray, i * 4 + 1);
            short s2 = Toad4PlusSimulator2.getShort(byArray, i * 4 + 2);
            bl = true;
        }
        if (bl) {
            System.out.println();
        }
    }

    public void setProbeSimulator(ProbeSimulatorInterface probeSimulatorInterface) {
        this.m_ProbeSimulator = probeSimulatorInterface;
    }

    @Override
    public byte[] sendMessage(byte[] byArray) {
        int n;
        int n2;
        int[] nArray = new int[this.m_NumberOfMotors + 1];
        for (n2 = 0; n2 < this.m_NumberOfMotors; ++n2) {
            int n3 = n = byArray[n2 * 8 + 1] & 0xF;
            nArray[n3] = nArray[n3] | 1 << n2;
        }
        for (n2 = 0; n2 < this.m_NumberOfMotors; ++n2) {
            this.m_StepperState[n2].processMotorCommands(byArray, n2, nArray);
        }
        this.runSimulation();
        if (byArray[0] == -2) {
            this.m_DataIn[0] = 2;
            this.m_DataIn[1] = 0;
            this.m_DataIn[2] = 1;
            this.m_DataIn[3] = (byte)this.m_NumberOfMotors;
            this.m_DataIn[62] = -1;
            Toad4PlusSimulator2.setInt(this.m_DataIn, 1, NCO_FREQ);
        } else {
            this.m_ProbeActive = true;
            for (n2 = 0; n2 < this.m_NumberOfMotors; ++n2) {
                n = this.m_StepperState[n2].getPosition();
                if (n2 < 3) {
                    // empty if block
                }
                if (!this.m_ProbeTriggered) {
                    Toad4PlusSimulator2.setInt(this.m_DataIn, n2 * 2, n);
                }
                int n4 = this.m_StepperState[n2].m_QueueSize;
                if (this.m_StepperState[n2].m_Busy) {
                    ++n4;
                }
                Toad4PlusSimulator2.setByte(this.m_DataIn, n2 * 8 + 4, (byte)(n4 + 128));
                boolean bl = false;
                int n5 = 1000 + 100 * n2;
                boolean bl2 = this.m_StepperState[n2].m_DirPolarity ? this.m_StepperState[n2].m_StepCount < -n5 : this.m_StepperState[n2].m_StepCount > n5;
                bl2 = bl2 == this.m_StepperState[n2].m_HomePolarity;
                Toad4PlusSimulator2.setByte(this.m_DataIn, n2 * 8 + 5, (byte)((bl |= bl2) ? 1 : 0));
            }
            this.m_ProbeTrigOn1 = (byArray[49] & 1) != 0;
            boolean bl = this.m_ProbeTrigOn0 = (byArray[49] & 2) != 0;
            if (this.m_ProbeSimulator != null) {
                double[] dArray = new double[3];
                StepperState[] stepperStateArray = this.m_StepperState;
                dArray[0] = (double)stepperStateArray[0].m_Position / stepperStateArray[0].m_StepSize * (double)(stepperStateArray[0].m_DirPolarity ? 1 : -1);
                dArray[1] = (double)stepperStateArray[1].m_Position / stepperStateArray[1].m_StepSize * (double)(stepperStateArray[1].m_DirPolarity ? 1 : -1);
                dArray[2] = (double)stepperStateArray[2].m_Position / stepperStateArray[2].m_StepSize * (double)(stepperStateArray[2].m_DirPolarity ? 1 : -1);
                this.m_ProbeActive = this.m_ProbeSimulator.getProbeState(dArray);
            } else {
                this.m_ProbeActive = false;
            }
            if (this.m_ProbeActive & this.m_ProbeTrigOn1) {
                this.m_ProbeTriggered = true;
            }
            if (!this.m_ProbeActive & this.m_ProbeTrigOn0) {
                this.m_ProbeTriggered = true;
            }
            if (!this.m_ProbeTrigOn1 && !this.m_ProbeTrigOn0) {
                this.m_ProbeTriggered = false;
            }
            Toad4PlusSimulator2.setByte(this.m_DataIn, 49, (byte)((this.m_ProbeActive ? 1 : 0) + (this.m_ProbeTriggered ? 2 : 0)));
        }
        this.m_DataIn[63] = byArray[63];
        return this.m_DataIn;
    }

    private static int getByte(byte[] byArray, int n) {
        return byArray[n];
    }

    private static void setByte(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
    }

    private static int getInt(byte[] byArray, int n) {
        n *= 4;
        return byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
    }

    private static void setInt(byte[] byArray, int n, int n2) {
        n *= 4;
        byArray[n++] = (byte)(n2 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >> 24 & 0xFF);
    }

    private static short getShort(byte[] byArray, int n) {
        n *= 2;
        return (short)(byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8);
    }

    private static void setShort(byte[] byArray, int n, int n2) {
        n *= 2;
        byArray[n++] = (byte)(n2 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
    }

    public static void mainx(String ... stringArray) {
        try {
            Toad4PlusSimulator2 toad4PlusSimulator2 = new Toad4PlusSimulator2(null);
            toad4PlusSimulator2.tryToOpenDevice();
            byte[] byArray = new byte[64];
            byte[] byArray2 = new byte[64];
            Toad4PlusSimulator2.setByte(byArray, 0, 1);
            Toad4PlusSimulator2.setByte(byArray, 1, 1);
            Toad4PlusSimulator2.setShort(byArray, 1, 266);
            Toad4PlusSimulator2.setShort(byArray, 2, 60000);
            Toad4PlusSimulator2.setByte(byArray, 8, 1);
            Toad4PlusSimulator2.setByte(byArray, 9, 1);
            Toad4PlusSimulator2.setShort(byArray, 5, 266);
            Toad4PlusSimulator2.setShort(byArray, 6, 30000);
            toad4PlusSimulator2.sendMessage(byArray);
            toad4PlusSimulator2.sendMessage(byArray);
            int n = 0;
            while (n++ < 100) {
                Toad4PlusSimulator2.setByte(byArray, 0, 0);
                Toad4PlusSimulator2.setByte(byArray, 8, 0);
                byte[] byArray3 = toad4PlusSimulator2.sendMessage(byArray);
            }
            toad4PlusSimulator2.tryToCloseDevice();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setPolarities(int n, boolean bl, boolean bl2) {
        if (n < 0 || n >= this.m_StepperState.length) {
            return;
        }
        this.m_StepperState[n].m_DirPolarity = bl2;
        this.m_StepperState[n].m_HomePolarity = bl;
    }

    public void setStepSize(int n, double d) {
        if (n < 0 || n >= this.m_StepperState.length) {
            return;
        }
        this.m_StepperState[n].m_StepSize = d;
    }

    @Override
    public boolean getAccessDenied() {
        return false;
    }

    public static class StepperState {
        static final int QUEUE_CAPACITY = 8;
        volatile int m_Position;
        volatile int m_Nco;
        volatile int m_Speed;
        volatile boolean m_Dir;
        volatile int m_StepCount = 0;
        volatile int m_Steps;
        volatile int m_NextSteps;
        volatile int m_NextSpeed;
        volatile boolean m_NextDir;
        volatile int m_LastSteps;
        volatile boolean m_LastDir;
        volatile int m_ReadyMask;
        volatile boolean m_Update;
        volatile QueueElement[] m_Queue;
        volatile int m_QueueFront;
        volatile int m_QueueRear;
        volatile int m_QueueSize;
        volatile boolean m_Ready;
        volatile boolean m_Busy;
        volatile boolean m_Empty;
        boolean m_DirPolarity;
        boolean m_HomePolarity;
        boolean m_ProbePolarity;
        double m_StepSize;
        Toad4PlusSimulator2 m_Toad4Simulator;
        int m_Motor;

        StepperState(Toad4PlusSimulator2 toad4PlusSimulator2, MachState machState, int n) {
            this.m_Motor = n;
            this.m_Toad4Simulator = toad4PlusSimulator2;
            this.m_Queue = new QueueElement[8];
            for (int i = 0; i < 8; ++i) {
                this.m_Queue[i] = new QueueElement();
            }
            Observer observer = observable -> {};
            machState.getVariable(-2147483644, n).addObserver(observer);
            machState.getVariable(-2147483643, n).addObserver(observer);
        }

        boolean queueEmpty() {
            return this.m_QueueSize == 0;
        }

        boolean queueFull() {
            return this.m_QueueSize >= this.m_Queue.length;
        }

        void pushQueue() {
            if (this.m_QueueSize >= 8) {
                System.err.println("StepperState:STACK OVERFLOW");
            }
            ++this.m_QueueSize;
            this.m_QueueRear = this.m_QueueRear < 7 ? ++this.m_QueueRear : 0;
        }

        void popQueue() {
            if (this.m_QueueSize <= 0) {
                System.err.println("StepperState:STACK UNDERFLOW");
            }
            this.m_QueueFront = this.m_QueueFront < 7 ? ++this.m_QueueFront : 0;
            --this.m_QueueSize;
        }

        void clearQueue() {
            this.m_QueueSize = 0;
            this.m_QueueFront = 0;
            this.m_QueueRear = 0;
        }

        void doNcoInterruptProcessing(int n, int n2, int n3) {
            this.m_Nco += this.m_Speed * n;
            int n4 = this.m_Nco & 0x10000;
            this.m_Nco &= 0xFFFF;
            if (this.m_Steps > 0) {
                if (n4 != 0) {
                    --this.m_Steps;
                    this.m_StepCount = this.m_Dir ? ++this.m_StepCount : --this.m_StepCount;
                }
            } else {
                this.m_Busy = false;
                if ((n2 & this.m_ReadyMask | n3 & this.m_ReadyMask) == 0) {
                    this.m_Toad4Simulator.m_SWI = true;
                    this.m_Update = true;
                    this.m_Busy = true;
                    this.m_Ready = true;
                    this.m_Steps = this.m_NextSteps;
                    this.m_Speed = this.m_NextSpeed;
                    this.m_Dir = this.m_NextDir;
                }
            }
        }

        int getPosition() {
            int n = this.m_LastSteps - this.m_Steps;
            if (this.m_LastDir) {
                return this.m_Position + n;
            }
            return this.m_Position - n;
        }

        void feedMore(Toad4PlusSimulator2 toad4PlusSimulator2) {
            if (this.m_Ready) {
                if (this.queueEmpty()) {
                    if (!this.m_Empty) {
                        this.m_Empty = true;
                        this.m_NextSteps = 0;
                        this.m_Update = true;
                        this.m_Toad4Simulator.m_SWI = true;
                    }
                } else {
                    int n = this.m_Queue[this.m_QueueFront].speed & 0xFFFF;
                    int n2 = this.m_Queue[this.m_QueueFront].move;
                    this.popQueue();
                    if (n2 < 0) {
                        n2 = -n2;
                        this.m_NextDir = false;
                    } else {
                        this.m_NextDir = true;
                    }
                    this.m_NextSteps = n2;
                    this.m_NextSpeed = n;
                    this.m_Ready = false;
                    this.m_Empty = false;
                }
            }
        }

        void updatePos(Toad4PlusSimulator2 toad4PlusSimulator2) {
            if (this.m_Update) {
                this.m_Update = false;
                this.m_Position = this.m_LastDir ? (this.m_Position += this.m_LastSteps) : (this.m_Position -= this.m_LastSteps);
                this.m_LastSteps = this.m_NextSteps;
                this.m_LastDir = this.m_NextDir;
            }
        }

        void reinitMotor(int n) {
            this.m_Position = 0;
            this.m_NextDir = false;
            this.m_LastDir = false;
            this.m_NextSteps = 0;
            this.m_LastSteps = 0;
            this.m_Steps = 0;
            this.m_Speed = 0;
            this.m_Position = 0;
            this.m_ReadyMask = 1 << n;
            this.m_Ready = true;
            this.clearQueue();
        }

        void resetMotor(int n) {
            this.m_NextDir = false;
            this.m_LastDir = false;
            this.m_NextSteps = 0;
            this.m_LastSteps = 0;
            this.m_Steps = 0;
            this.m_Speed = 0;
            this.m_ReadyMask = 1 << n;
            this.m_Ready = true;
            this.clearQueue();
        }

        void processMotorCommands(byte[] byArray, int n, int[] nArray) {
            byte by = byArray[n * 8 + 0];
            byte by2 = byArray[n * 8 + 1];
            int n2 = by2 & 0xF;
            this.m_ReadyMask = nArray[n2];
            if (by == 1) {
                short s = Toad4PlusSimulator2.getShort(byArray, n * 4 + 1);
                short s2 = Toad4PlusSimulator2.getShort(byArray, n * 4 + 2);
                this.m_Queue[this.m_QueueRear].move = s;
                this.m_Queue[this.m_QueueRear].speed = s2;
                if (s2 > 17000) {
                    System.out.println("speed > 17000");
                }
                this.pushQueue();
                this.m_Toad4Simulator.m_SWI = true;
            } else if (by == 2) {
                this.m_Position = Toad4PlusSimulator2.getInt(byArray, n * 2 + 1);
            } else if (by == 3) {
                this.reinitMotor(n);
            } else if (by == 4) {
                this.resetMotor(n);
            }
        }
    }

    public static interface ProbeSimulatorInterface {
        public boolean getProbeState(double[] var1);

        public void setProbeOrienation(boolean var1);

        public void setProbeSizeAndOffset(double var1, double var3, double var5);
    }

    private static class QueueElement {
        int move;
        int speed;

        private QueueElement() {
        }
    }
}

