/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import virtualmill3ax.OpenGLWindow;

public class AuxStuff {
    public static int[] loadPath(String string) {
        try {
            String string2;
            ArrayList<Float> arrayList = new ArrayList<Float>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = 0;
                arrayList.add(Float.valueOf(Float.parseFloat(string2.substring(n, n + 9))));
                arrayList.add(Float.valueOf(Float.parseFloat(string2.substring(n += 9, n + 9))));
                arrayList.add(Float.valueOf(Float.parseFloat(string2.substring(n += 9, n + 9))));
                n += 9;
            }
            System.out.println("read in " + arrayList.size() / 3 + " tuplets");
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2++] = (int)(0.5 + (double)(((Float)arrayList.get(n++)).floatValue() * 10.0f));
                nArray[n2++] = (int)(0.5 + (double)(((Float)arrayList.get(n++)).floatValue() * 10.0f));
                nArray[n2++] = (int)(0.5 + (double)(((Float)arrayList.get(n++)).floatValue() * 10.0f));
            }
            return nArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveHeightmapToFile(int[] nArray, String string) {
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
                FileChannel fileChannel = randomAccessFile.getChannel();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 4 * nArray.length);
                for (int n : nArray) {
                    mappedByteBuffer.putInt(n);
                }
                fileChannel.close();
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static OpenGLWindow showHeightmapAs3D(int[] nArray, int n, int n2) {
        if (nArray != null) {
            float[] fArray = new float[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                fArray[i] = nArray[i];
            }
            return new OpenGLWindow(fArray, n, n2);
        }
        int n3 = 24;
        int n4 = 16;
        float[] fArray = new float[n3 * n4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                float f = 0.0f;
                if (j == 1 || i == 1) {
                    f = 1.0f;
                }
                fArray[j + i * n3] = f;
            }
        }
        return new OpenGLWindow(fArray, n3, n4);
    }

    public static void showHeightmapAsImage(int[] nArray, int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n3 = Math.min(n3, nArray[i]);
            n4 = Math.max(n4, nArray[i]);
        }
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((nArray[i] - n3) * 255 / (n4 - n3));
        }
        final BufferedImage bufferedImage = AuxStuff.getGrayscale(n, n2, byArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame("Demo"){

                    @Override
                    public void paint(Graphics graphics) {
                        super.paint(graphics);
                        graphics.drawImage(bufferedImage, 0, 0, null);
                    }
                };
                jFrame.setLocationRelativeTo(null);
                jFrame.setSize(1600, 1200);
                jFrame.setVisible(true);
            }
        });
    }

    public static BufferedImage getGrayscale(int n, int n2, byte[] byArray) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nArray = new int[]{8};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 0);
        SampleModel sampleModel = ((ColorModel)componentColorModel).createCompatibleSampleModel(n, n2);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage;
    }
}

