/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class Demo {
    static final int tool_size = 128;
    static final int stock_size_x = 800;
    static final int stock_size_y = 600;
    static final int N = 100000;
    private static final String kernelFunction = "kernel void millcut(\t\t\t\t\t\t\t\t\t\t\t\t\t\tglobal const float* tool, \t\t\t\t\t\t\t\t\t\t\t \tglobal float* stock, \t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_x, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_y, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_z \t\t\t\t\t\t\t\t\t\t\t\t\t\t \t) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \tint x=get_global_id(0);\t\t\t\t\t\t\t\t\t\t\t\t \tint y=get_global_id(1);\t\t\t\t\t\t\t\t\t\t\t\t \tint si = (x + tool_pos_x) + (y + tool_pos_y) * stock_size;\t\t\t\tint ti = x + y * tool_size;\t\t\t\t\t\t\t\t\t\t\t\tint h=tool[ti]+tool_pos_z;\t\t\t\t\t\t\t\t\t\t\t\tif (stock[si] > h)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tstock[si] = h;\t\t\t\t\t\t\t\t\t\t\t\t\t}";
    private static final String kernelFunction2 = "kernel void millcut(\t\t\t\t\t\t\t\t\t\t\t\t\t\tglobal const float* tool, \t\t\t\t\t\t\t\t\t\t\t \tglobal float* stock, \t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_x, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_y, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_z \t\t\t\t\t\t\t\t\t\t\t\t\t\t \t) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \tint x=get_global_id(0);\t\t\t\t\t\t\t\t\t\t\t\t \tint y=get_global_id(1);\t\t\t\t\t\t\t\t\t\t\t\t\tstock[x+y*stock_size] = 0;\t\t\t\t\t\t\t\t\t\t\t\t\t}";

    public static void main(String[] stringArray) throws IOException {
        new Demo().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        try {
            boolean bl = Platform.AWT_AVAILABLE;
            CLContext cLContext = CLContext.create();
            System.out.println("created " + cLContext);
            try {
                CLDevice cLDevice2;
                for (CLDevice cLDevice2 : cLContext.getDevices()) {
                    System.out.println("available device " + cLDevice2);
                }
                CLDevice cLDevice3 = cLContext.getDevices()[0];
                System.out.println("using " + cLDevice3);
                CLCommandQueue cLCommandQueue = cLDevice3.createCommandQueue();
                CLProgram cLProgram = cLContext.createProgram(kernelFunction);
                cLProgram.build(new String[]{String.format("-Dstock_size=%d", 800), String.format("-Dtool_size=%d", 128)});
                cLDevice2 = cLContext.createFloatBuffer(16384, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                CLBuffer cLBuffer = cLContext.createFloatBuffer(480000, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
                System.out.println("used device memory: " + (cLDevice2.getCLSize() + cLBuffer.getCLSize()) / 1000000L + "MB");
                Demo.fillBuffer((FloatBuffer)cLBuffer.getBuffer(), 128.0f);
                for (int i = 0; i < 16384; ++i) {
                    ((FloatBuffer)cLDevice2.getBuffer()).put(10.0f);
                }
                ((FloatBuffer)cLDevice2.getBuffer()).rewind();
                ((FloatBuffer)cLDevice2.getBuffer()).put(Demo.createToolHeightMap(128));
                ((FloatBuffer)cLDevice2.getBuffer()).rewind();
                CLKernel cLKernel = cLProgram.createCLKernel("millcut");
                cLKernel.putArg((CLMemory)cLDevice2);
                cLKernel.putArg((CLMemory)cLBuffer);
                cLCommandQueue.putWriteBuffer((CLBuffer)cLDevice2, false);
                cLCommandQueue.putWriteBuffer(cLBuffer, false);
                long l = 0L;
                long l2 = System.nanoTime();
                for (int i = 0; i < 100000; ++i) {
                    int n = i % 700;
                    cLKernel.setArg(2, n);
                    cLKernel.setArg(3, n / 2);
                    cLKernel.setArg(4, n / 3);
                    cLCommandQueue.put2DRangeKernel(cLKernel, 0L, 0L, 128L, 128L, 0L, 0L);
                }
                l = System.nanoTime() - l2;
                System.out.println("submitting computation took: " + l / 1000000L + " ms");
                cLCommandQueue.finish();
                l = System.nanoTime() - l2;
                System.out.println("total computation took: " + l / 1000000L + "ms");
                System.out.println("time per height op " + (double)l / 1.6384E9 + " ns");
                System.out.println("2DRange-ops / sec " + 100000000000000L / l);
                cLCommandQueue.putReadBuffer(cLBuffer, true).finish();
                FloatBuffer floatBuffer = (FloatBuffer)cLBuffer.getBuffer();
                byte[] byArray = new byte[480000];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (byte)floatBuffer.get(i);
                }
                final BufferedImage bufferedImage = Demo.getGrayscale(800, 600, byArray);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame jFrame = new JFrame(this.getClass().getSimpleName());
                        jFrame.add(new JLabel(new ImageIcon(bufferedImage)));
                        jFrame.pack();
                        jFrame.setLocationRelativeTo(null);
                        jFrame.setVisible(true);
                    }
                });
            }
            finally {
                cLContext.release();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static BufferedImage getGrayscale(int n, int n2, byte[] byArray) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nArray = new int[]{8};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 0);
        SampleModel sampleModel = ((ColorModel)componentColorModel).createCompatibleSampleModel(n, n2);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    private static void fillBuffer(FloatBuffer floatBuffer, float f) {
        while (floatBuffer.remaining() != 0) {
            floatBuffer.put(f);
        }
        floatBuffer.rewind();
    }

    private static float[] createToolHeightMap(int n) {
        int n2 = n / 2;
        float[] fArray = new float[n * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = (double)(j - n2) + 0.5;
                double d2 = (double)(i - n2) + 0.5;
                double d3 = (double)(n2 * n2) - d * d - d2 * d2;
                d3 = d3 >= 0.0 ? (double)n2 - Math.sqrt(d3) : 3.4028234663852886E38;
                fArray[j + i * n] = (float)d3;
            }
        }
        return fArray;
    }
}

