/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import com.jogamp.opengl.GL2;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class GLShape {
    private FloatBuffer m_VertexBuffer;
    private FloatBuffer m_NormalBuffer;
    private ShortBuffer m_IndexBufferShort;
    private IntBuffer m_IndexBufferInt;
    private int m_Type;
    static int m_IdCount = 0;
    public int m_Id = m_IdCount++;
    private static final float PI2 = (float)Math.PI * 2;
    private static final float PI = (float)Math.PI;

    public GLShape(int n, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, ShortBuffer shortBuffer) {
        this.m_Type = n;
        this.m_VertexBuffer = floatBuffer;
        this.m_NormalBuffer = floatBuffer2;
        this.m_IndexBufferShort = shortBuffer;
    }

    public GLShape(int n, float[] fArray, float[] fArray2, short[] sArray) {
        this.m_Type = n;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.m_VertexBuffer = byteBuffer.asFloatBuffer();
        this.m_VertexBuffer.position(0);
        this.m_VertexBuffer.put(fArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(fArray2.length * 4);
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.m_NormalBuffer = byteBuffer2.asFloatBuffer();
        this.m_NormalBuffer.position(0);
        this.m_NormalBuffer.put(fArray2);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(sArray.length * 2);
        byteBuffer3.order(ByteOrder.nativeOrder());
        this.m_IndexBufferShort = byteBuffer3.asShortBuffer();
        this.m_IndexBufferShort.position(0);
        this.m_IndexBufferShort.put(sArray);
    }

    public GLShape(int n, float[] fArray, float[] fArray2, int[] nArray) {
        this.m_Type = n;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.m_VertexBuffer = byteBuffer.asFloatBuffer();
        this.m_VertexBuffer.position(0);
        this.m_VertexBuffer.put(fArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(fArray2.length * 4);
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.m_NormalBuffer = byteBuffer2.asFloatBuffer();
        this.m_NormalBuffer.position(0);
        this.m_NormalBuffer.put(fArray2);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(nArray.length * 4);
        byteBuffer3.order(ByteOrder.nativeOrder());
        this.m_IndexBufferInt = byteBuffer3.asIntBuffer();
        this.m_IndexBufferInt.position(0);
        this.m_IndexBufferInt.put(nArray);
    }

    public static GLShape createLines(float[] fArray) {
        int n = fArray.length;
        if (n < 6) {
            throw new IllegalArgumentException("At least two vertixes required");
        }
        if (n % 6 != 0) {
            throw new IllegalArgumentException("Even number of vertexes required");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.position(0);
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return new GLShape(1, floatBuffer, null, null);
    }

    public static GLShape createDisk(float f, int n) {
        int n2;
        int n3 = n + 1;
        float[] fArray = new float[3 * n3];
        int n4 = 0;
        float[] fArray2 = new float[3 * n3];
        int n5 = 0;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = (float)Math.PI * 2 / (float)n;
        float f5 = (float)Math.cos(f4);
        float f6 = (float)Math.sin(f4);
        for (n2 = 0; n2 < n; ++n2) {
            fArray[n4++] = f2 * f;
            fArray[n4++] = f3 * f;
            fArray[n4++] = 0.0f;
            fArray2[n5++] = 0.0f;
            fArray2[n5++] = 0.0f;
            fArray2[n5++] = 1.0f;
            float f7 = f5 * f2 - f6 * f3;
            float f8 = f6 * f2 + f5 * f3;
            f2 = f7;
            f3 = f8;
        }
        fArray[n4++] = 0.0f;
        fArray[n4++] = 0.0f;
        fArray[n4++] = 0.0f;
        fArray2[n5++] = 0.0f;
        fArray2[n5++] = 0.0f;
        fArray2[n5++] = 1.0f;
        n2 = 3 * n;
        short[] sArray = new short[n2];
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            sArray[n6++] = (short)i;
            sArray[n6++] = (short)((i + 1) % n);
            sArray[n6++] = (short)n;
        }
        return new GLShape(4, fArray, fArray2, sArray);
    }

    public static GLShape createCylinder(float f, float f2, float f3, int n, int n2) {
        int n3;
        int n4;
        if (n < 4) {
            throw new IllegalArgumentException("slices < 4");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("stacks < 1");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("height < 0");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("baseRadius < 0");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("topRadius < 0");
        }
        int n5 = n * (n2 + 1);
        float[] fArray = new float[3 * n5];
        int n6 = 0;
        float[] fArray2 = new float[3 * n5];
        int n7 = 0;
        float f4 = (float)Math.PI * 2 / (float)n;
        float f5 = (float)Math.cos(f4);
        float f6 = (float)Math.sin(f4);
        float f7 = f2 - f;
        float f8 = (float)Math.sqrt(f7 * f7 + f3 * f3);
        float f9 = f3 / f8;
        float f10 = 0.0f;
        float f11 = -f7 / f8;
        for (n4 = 0; n4 <= n2; ++n4) {
            float f12 = f + f7 * (float)n4 / (float)n2;
            float f13 = 1.0f;
            float f14 = 0.0f;
            float f15 = f3 * (float)n4 / (float)n2;
            for (n3 = 0; n3 < n; ++n3) {
                fArray[n6++] = f13 * f12;
                fArray[n6++] = f14 * f12;
                fArray[n6++] = f15;
                fArray2[n7++] = f9;
                fArray2[n7++] = f10;
                fArray2[n7++] = f11;
                float f16 = f5 * f13 - f6 * f14;
                float f17 = f6 * f13 + f5 * f14;
                f13 = f16;
                f14 = f17;
                f16 = f5 * f9 - f6 * f10;
                f17 = f6 * f9 + f5 * f10;
                f9 = f16;
                f10 = f17;
            }
        }
        n4 = 3 * (n * n2 * 2);
        short[] sArray = new short[n4];
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                n3 = i * n + j;
                int n9 = i * n + (j + 1) % n;
                int n10 = (i + 1) * n + j;
                int n11 = (i + 1) * n + (j + 1) % n;
                sArray[n8++] = (short)n3;
                sArray[n8++] = (short)n9;
                sArray[n8++] = (short)n10;
                sArray[n8++] = (short)n10;
                sArray[n8++] = (short)n9;
                sArray[n8++] = (short)n11;
            }
        }
        return new GLShape(4, fArray, fArray2, sArray);
    }

    public static GLShape createSphere(float f, int n, int n2) {
        int n3;
        if (n < 4) {
            throw new IllegalArgumentException("slices < 4");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("stacks < 2");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("radius < 0");
        }
        int n4 = n * (n2 - 1) + 2;
        float[] fArray = new float[3 * n4];
        int n5 = 0;
        float[] fArray2 = new float[3 * n4];
        int n6 = 0;
        float f2 = (float)Math.PI / (float)n2;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = -1.0f;
        float f8 = (float)Math.PI * 2 / (float)n;
        float f9 = (float)Math.cos(f8);
        float f10 = (float)Math.sin(f8);
        for (n3 = 0; n3 <= n2; ++n3) {
            float f11;
            if (n3 > 0 && n3 < n2) {
                for (int i = 0; i < n; ++i) {
                    fArray[n5++] = f6 * f;
                    fArray[n5++] = f5 * f;
                    fArray[n5++] = f7 * f;
                    fArray2[n6++] = f6;
                    fArray2[n6++] = f5;
                    fArray2[n6++] = f7;
                    f11 = f9 * f6 - f10 * f5;
                    float f12 = f10 * f6 + f9 * f5;
                    f6 = f11;
                    f5 = f12;
                }
            } else {
                fArray[n5++] = f6 * f;
                fArray[n5++] = f5 * f;
                fArray[n5++] = f7 * f;
                fArray2[n6++] = f6;
                fArray2[n6++] = f5;
                fArray2[n6++] = f7;
            }
            float f13 = f3 * f6 - f4 * f7;
            f11 = f4 * f6 + f3 * f7;
            f6 = f13;
            f7 = f11;
        }
        n3 = 3 * (n * n2 * 2);
        short[] sArray = new short[n3];
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n8 = 1 + (i - 1) * n + j;
                int n9 = 1 + (i - 1) * n + (j + 1) % n;
                int n10 = 1 + i * n + j;
                int n11 = 1 + i * n + (j + 1) % n;
                if (i == 0) {
                    sArray[n7++] = (short)n10;
                    sArray[n7++] = 0;
                    sArray[n7++] = (short)n11;
                    continue;
                }
                if (i == n2 - 1) {
                    sArray[n7++] = (short)n8;
                    sArray[n7++] = (short)n9;
                    sArray[n7++] = (short)(n4 - 1);
                    continue;
                }
                sArray[n7++] = (short)n8;
                sArray[n7++] = (short)n9;
                sArray[n7++] = (short)n10;
                sArray[n7++] = (short)n10;
                sArray[n7++] = (short)n9;
                sArray[n7++] = (short)n11;
            }
        }
        return new GLShape(4, fArray, fArray2, sArray);
    }

    private static void estimateNormal(int n, int n2, int n3, float[] fArray, float[] fArray2) {
        int n4 = n * 3;
        int n5 = n2 * 3;
        int n6 = n3 * 3;
        Vector3f vector3f = new Vector3f(fArray[n4 + 0], fArray[n4 + 1], fArray[n4 + 2]);
        Vector3f vector3f2 = new Vector3f(fArray[n5 + 0], fArray[n5 + 1], fArray[n5 + 2]);
        Vector3f vector3f3 = new Vector3f(fArray[n6 + 0], fArray[n6 + 1], fArray[n6 + 2]);
        vector3f2.sub((Tuple3f)vector3f);
        vector3f3.sub((Tuple3f)vector3f);
        Vector3f vector3f4 = new Vector3f();
        vector3f4.cross(vector3f2, vector3f3);
        vector3f4.normalize();
        int n7 = n4 + 0;
        fArray2[n7] = fArray2[n7] + vector3f4.x;
        int n8 = n4 + 1;
        fArray2[n8] = fArray2[n8] + vector3f4.y;
        int n9 = n4 + 2;
        fArray2[n9] = fArray2[n9] + vector3f4.z;
        int n10 = n5 + 0;
        fArray2[n10] = fArray2[n10] + vector3f4.x;
        int n11 = n5 + 1;
        fArray2[n11] = fArray2[n11] + vector3f4.y;
        int n12 = n5 + 2;
        fArray2[n12] = fArray2[n12] + vector3f4.z;
        int n13 = n6 + 0;
        fArray2[n13] = fArray2[n13] + vector3f4.x;
        int n14 = n6 + 1;
        fArray2[n14] = fArray2[n14] + vector3f4.y;
        int n15 = n6 + 2;
        fArray2[n15] = fArray2[n15] + vector3f4.z;
    }

    static GLShape createHeightMap(int n, int n2, float f, float f2, int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        return GLShape.createHeightMap(n, n2, f, f2, fArray);
    }

    static GLShape createHeightMap(int n, int n2, float f, float f2, float[] fArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n * n2;
        float[] fArray2 = new float[3 * n7];
        int n8 = 0;
        float f3 = (float)(n - 1) * f / 2.0f;
        float f4 = (float)(n2 - 1) * f2 / 2.0f;
        for (int i = 0; i < n2; ++i) {
            for (n6 = 0; n6 < n; ++n6) {
                fArray2[n8++] = f * (float)n6 - f3;
                fArray2[n8++] = f2 * (float)i - f4;
                fArray2[n8++] = fArray[n6 + i * n];
            }
        }
        float[] fArray3 = new float[3 * n7];
        n6 = (n2 - 1) * (n - 1) * 6;
        int[] nArray = new int[n6];
        int n9 = 0;
        for (n5 = 0; n5 < n2 - 1; ++n5) {
            for (n4 = 0; n4 < n - 1; ++n4) {
                n3 = n4 + n5 * n;
                int n10 = 1 + n4 + n5 * n;
                int n11 = n4 + (n5 + 1) * n;
                int n12 = 1 + n4 + (n5 + 1) * n;
                nArray[n9++] = n3;
                nArray[n9++] = n10;
                nArray[n9++] = n11;
                nArray[n9++] = n11;
                nArray[n9++] = n10;
                nArray[n9++] = n12;
                GLShape.estimateNormal(n3, n10, n11, fArray2, fArray3);
                GLShape.estimateNormal(n11, n10, n12, fArray2, fArray3);
            }
        }
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = (n4 + n5 * n) * 3;
                Vector3f vector3f = new Vector3f(fArray3[n3 + 0], fArray3[n3 + 1], fArray3[n3 + 2]);
                vector3f.normalize();
                fArray3[n3 + 0] = vector3f.x;
                fArray3[n3 + 1] = vector3f.y;
                fArray3[n3 + 2] = vector3f.z;
            }
        }
        if (n7 > 65535) {
            return new GLShape(4, fArray2, fArray3, nArray);
        }
        short[] sArray = new short[nArray.length];
        for (n4 = 0; n4 < sArray.length; ++n4) {
            sArray[n4] = (short)nArray[n4];
        }
        return new GLShape(4, fArray2, fArray3, sArray);
    }

    static void sweep(float[] fArray, float[] fArray2, int n, float f, float f2) {
    }

    static void extrude(float[] fArray, float[] fArray2, int n, float f) {
    }

    static void mesh(float[] fArray, float[] fArray2, float[] fArray3) {
    }

    public void transform(Matrix4f matrix4f) {
        int n = this.m_VertexBuffer.limit();
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        this.m_VertexBuffer.get(fArray);
        this.m_NormalBuffer.get(fArray2);
        Point3f point3f = new Point3f();
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < n; i += 3) {
            point3f.x = fArray[i + 0];
            point3f.y = fArray[i + 1];
            point3f.z = fArray[i + 2];
            vector3f.x = fArray2[i + 0];
            vector3f.y = fArray2[i + 1];
            vector3f.z = fArray2[i + 2];
            matrix4f.transform(point3f);
            matrix4f.transform(vector3f);
        }
        this.m_VertexBuffer.position(0);
        this.m_VertexBuffer.put(fArray);
        this.m_NormalBuffer.position(0);
        this.m_NormalBuffer.put(fArray2);
    }

    public void render(GL2 gL2) {
        this.m_VertexBuffer.position(0);
        if (this.m_NormalBuffer != null) {
            this.m_NormalBuffer.position(0);
        }
        gL2.glEnableClientState(32884);
        gL2.glVertexPointer(3, 5126, 0, (Buffer)this.m_VertexBuffer);
        if (this.m_NormalBuffer != null) {
            gL2.glEnableClientState(32885);
            gL2.glNormalPointer(5126, 0, (Buffer)this.m_NormalBuffer);
        }
        if (this.m_IndexBufferShort != null) {
            this.m_IndexBufferShort.position(0);
            gL2.glDrawElements(this.m_Type, this.m_IndexBufferShort.limit(), 5123, (Buffer)this.m_IndexBufferShort);
        } else if (this.m_IndexBufferInt != null) {
            this.m_IndexBufferInt.position(0);
            gL2.glDrawElements(this.m_Type, this.m_IndexBufferInt.limit(), 5125, (Buffer)this.m_IndexBufferInt);
        } else {
            gL2.glDrawArrays(this.m_Type, 0, this.m_VertexBuffer.limit() / 3);
        }
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32885);
    }
}

