/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import eazycnc.Main;
import eazycnc.gcode.FilePos;
import eazycnc.gcode.FileReader;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import eazycnc.gcode.Machcode;
import eazycnc.gcode.Parser;
import eazycnc.gcode.Preprocessor;
import eazycnc.gcode.RadiusCompensator;
import eazycnc.planner.MovePipeline;
import eazycnc.planner.QuinticToolPathPlanner;
import virtualmill3ax.AuxStuff;
import virtualmill3ax.GLShape;
import virtualmill3ax.OpenGLWindow;
import virtualmill3ax.VirtualStock;
import virtualmill3ax.VirtualTool;

public class MachSimulator
implements Preprocessor {
    private OpenGLWindow m_OpenGLWindow;
    private MachState m_State;
    private VirtualStock m_Stock;
    private VirtualTool m_Tool;
    private VirtualTool[] m_Tools = new VirtualTool[257];
    private int m_ToolNo = -1;
    private long m_t0;
    private int m_MoveIndex;
    private int[] m_Moves = new int[0x600000];
    private double m_Reso = 0.1;
    private double m_SizeX;
    private double m_SizeY;
    private double m_SizeZ;
    private double m_OriginX;
    private double m_OriginY;
    private double m_OriginZ;
    private double m_ShankDia;
    private double m_CutDia;
    private double m_CornerRadius;
    private double m_FaceAngle;
    private double m_SideAngle;
    String filename;
    FileReader.FileAccessor accessor;
    MachState state;
    Object sema4 = new Object();
    volatile Command m_Cmd;

    public MachSimulator() {
        new Thread(() -> this.runInBackground()).start();
        this.m_OpenGLWindow = AuxStuff.showHeightmapAs3D(null, 100, 100);
        this.m_OpenGLWindow.run();
    }

    private void processMoves(FilePos filePos) {
        if (this.m_Stock == null) {
            return;
        }
        if (this.m_MoveIndex == 0) {
            return;
        }
        this.m_t0 = System.nanoTime();
        this.m_Stock.queueCut(this.m_Moves, 0, 3, this.m_MoveIndex / 3);
        this.m_Stock.finalizeCut();
        long l = System.nanoTime();
        long l2 = (long)(this.m_MoveIndex / 3) * (long)this.m_Tool.getSize() * (long)this.m_Tool.getSize();
        long l3 = l - this.m_t0;
        this.m_MoveIndex = 0;
        this.m_OpenGLWindow.updateHeightMap(GLShape.createHeightMap(this.m_Stock.getSizeX(), this.m_Stock.getSizeY(), 1.0f, 1.0f, this.m_Stock.getHeightMap()), filePos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInBackground() {
        block16: while (true) {
            Object object = this.sema4;
            synchronized (object) {
                while (this.m_Cmd != Command.START) {
                    if (this.m_Cmd == Command.STOP) {
                        this.m_Cmd = Command.STOPPED;
                    }
                    try {
                        this.sema4.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                this.m_Cmd = Command.STARTED;
            }
            try {
                this.m_Stock = null;
                this.m_Tool = null;
                this.m_Tools = new VirtualTool[257];
                this.m_ToolNo = -1;
                this.m_State = this.state;
                object = new Interpreter();
                Parser parser = new Parser((Interpreter)object);
                Machcode machcode = parser.parseFile(this.state, this.accessor, this.filename, null);
                double d = this.state.getParamDouble(15171) / 100.0;
                if (!this.state.getParamBoolean(15170)) {
                    d = 0.0;
                }
                double d2 = this.state.getParamDouble(15173) / 100.0;
                RadiusCompensator.process(machcode, d, d2);
                MovePipeline movePipeline = new MovePipeline(){
                    Object m_CurrentTag = null;

                    @Override
                    public void queueMove(Object object, double[] dArray) throws InterruptedException {
                        int n = MachSimulator.this.m_State.getParamInt(15147);
                        if (object != this.m_CurrentTag) {
                            this.m_CurrentTag = object;
                            MachSimulator.this.processMoves(((Machcode)object).m_FilePos);
                        }
                        if (MachSimulator.this.m_ToolNo != n && MachSimulator.this.m_Stock != null) {
                            MachSimulator.this.processMoves(null);
                            MachSimulator.this.m_ToolNo = n;
                            MachSimulator.this.m_Tool = MachSimulator.this.m_Tools[n];
                            if (MachSimulator.this.m_Tool == null) {
                                int n2 = (int)(MachSimulator.this.m_State.getParamDouble(0x40000000, MachSimulator.this.m_ToolNo - 1) / MachSimulator.this.m_Reso);
                                MachSimulator.this.m_Tool = new VirtualTool((int)((double)n2 / MachSimulator.this.m_Reso));
                            }
                            MachSimulator.this.m_Stock.setTool(MachSimulator.this.m_Tool);
                            System.out.println("TOOL CHANGE " + n);
                            return;
                        }
                        if (MachSimulator.this.m_MoveIndex + 3 >= MachSimulator.this.m_Moves.length) {
                            MachSimulator.this.processMoves(null);
                        }
                        MachSimulator.this.m_Moves[MachSimulator.this.m_MoveIndex++] = (int)(dArray[0] / MachSimulator.this.m_Reso);
                        MachSimulator.this.m_Moves[MachSimulator.this.m_MoveIndex++] = (int)(dArray[1] / MachSimulator.this.m_Reso);
                        MachSimulator.this.m_Moves[MachSimulator.this.m_MoveIndex++] = (int)(dArray[2] / MachSimulator.this.m_Reso);
                    }

                    @Override
                    public void flush() throws InterruptedException {
                        MachSimulator.this.processMoves(null);
                    }
                };
                QuinticToolPathPlanner quinticToolPathPlanner = new QuinticToolPathPlanner("SIMULATION", 6, movePipeline, null);
                quinticToolPathPlanner.setParameters(this.state.getParamDouble(15172), this.state.getParamDouble(15150), this.state.getParamDouble(15149), this.state.getParamDouble(15148), this.state.getParamDouble(15169));
                double[] dArray = new double[6];
                for (int i = 0; i < 6; ++i) {
                    dArray[i] = this.state.getParamDouble(-2147483633, i);
                }
                quinticToolPathPlanner.setScalers(dArray);
                quinticToolPathPlanner.startPlanner(true, this.state.getAxisPos());
                Machcode machcode2 = machcode;
                block19: while (machcode2 != null) {
                    if (this.m_Cmd == Command.STOP) continue block16;
                    try {
                        switch (machcode2.m_Type) {
                            default: {
                                quinticToolPathPlanner.flush();
                                break;
                            }
                            case COMMENT: {
                                this.preprocess(((Machcode.Comment)machcode2).m_Comment);
                                break;
                            }
                            case STOP: {
                                machcode2 = null;
                                break block19;
                            }
                            case SET_PARAMETER: {
                                quinticToolPathPlanner.flush();
                                Machcode.SetParameter setParameter = (Machcode.SetParameter)machcode2;
                                this.state.setParam(setParameter.m_Parameter, setParameter.m_Value);
                                break;
                            }
                            case MOVE_LINEAR: 
                            case MOVE_ARC_CCW: 
                            case MOVE_ARC_CW: {
                                double d3 = machcode2.getVelocity();
                                if (d3 == 0.0) {
                                    d3 = this.state.getParamDouble(15149);
                                }
                                quinticToolPathPlanner.queueSegment(d3, machcode2);
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    machcode2 = machcode2.m_Next;
                }
                quinticToolPathPlanner.flush();
                if (this.m_Stock == null) continue;
                this.m_OpenGLWindow.updateHeightMap(GLShape.createHeightMap(this.m_Stock.getSizeX(), this.m_Stock.getSizeY(), 1.0f, 1.0f, this.m_Stock.getHeightMap()), null);
                continue;
            }
            catch (Parser.ParseException parseException) {
                parseException.printStackTrace();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static double parseNum(String string) {
        return Double.parseDouble(string);
    }

    @Override
    public String preprocess(String string) {
        try {
            String string2 = "%!SIMU ";
            if (string.startsWith(string2)) {
                String[] stringArray = string.split(" ");
                String string3 = stringArray[1];
                int n = 2;
                int n2 = stringArray.length;
                if ("STOCK".equals(string3)) {
                    this.m_Reso = MachSimulator.parseNum(stringArray[n++]);
                    this.m_SizeX = MachSimulator.parseNum(stringArray[n++]);
                    this.m_SizeY = MachSimulator.parseNum(stringArray[n++]);
                    this.m_SizeZ = MachSimulator.parseNum(stringArray[n++]);
                    this.m_OriginX = 0.0;
                    this.m_OriginY = 0.0;
                    this.m_OriginZ = this.m_SizeZ;
                    if (n < n2) {
                        this.m_OriginX = MachSimulator.parseNum(stringArray[n++]);
                        if (n < n2) {
                            this.m_OriginY = MachSimulator.parseNum(stringArray[n++]);
                            if (n < n2) {
                                this.m_OriginZ = MachSimulator.parseNum(stringArray[n++]);
                            }
                        }
                    }
                    System.out.printf("STOCK SIZE %f %f %f \n", this.m_SizeX, this.m_SizeY, this.m_SizeZ);
                    this.m_Stock = new VirtualStock(0);
                    this.m_Stock.createSquereStock((int)(this.m_OriginX / this.m_Reso), (int)(this.m_OriginY / this.m_Reso), (int)(this.m_OriginZ / this.m_Reso), (int)(this.m_SizeX / this.m_Reso), (int)(this.m_SizeY / this.m_Reso), (int)(this.m_SizeZ / this.m_Reso));
                }
                if ("TOOL".equals(string3)) {
                    int n3 = (int)MachSimulator.parseNum(stringArray[n++]);
                    this.m_ShankDia = MachSimulator.parseNum(stringArray[n++]);
                    this.m_CutDia = MachSimulator.parseNum(stringArray[n++]);
                    this.m_CornerRadius = MachSimulator.parseNum(stringArray[n++]);
                    this.m_FaceAngle = MachSimulator.parseNum(stringArray[n++]);
                    this.m_SideAngle = MachSimulator.parseNum(stringArray[n++]);
                    this.m_Tools[n3] = new VirtualTool(this.m_ShankDia / this.m_Reso, this.m_CutDia / this.m_Reso, this.m_CornerRadius / this.m_Reso, Math.toRadians(this.m_FaceAngle), Math.toRadians(this.m_SideAngle));
                }
                return "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resimulate() {
        Object object = this.sema4;
        synchronized (object) {
            this.m_Cmd = Command.STOP;
            while (this.m_Cmd != Command.STOPPED) {
                try {
                    this.sema4.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.state = new MachState("SIMULATION", Main.m_Main.m_ActualMachState);
            this.accessor = Main.m_Main.m_GCodeEditor.getFileAccessorForMainFile();
            this.filename = Main.m_Main.m_GCodeEditor.getMainProgramFile().getName();
            this.m_Cmd = Command.START;
            this.sema4.notifyAll();
        }
    }

    static enum Command {
        START,
        STOP,
        STARTED,
        STOPPED;

    }
}

