/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLImage3d;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.glu.GLU;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.vecmath.Vector3f;

public class Main {
    static CLCommandQueue queue;
    static GLU glu;
    static final int SIZE_OF_FLOAT = 4;
    static int windowWidth;
    static int windowHeight;
    static int[] VBO_ID;
    static boolean extractSurfaceOnEveryFrame;
    static boolean extractSurface;
    static Vector3f scalingFactor;
    static Vector3f translation;
    static float camX;
    static float camY;
    static float camZ;
    static float lastx;
    static float lasty;
    static float xrot;
    static float yrot;
    static float xrotrad;
    static float yrotrad;
    static float speed;
    static boolean writingTo3DTextures;
    static CLImage3d[] images;
    static CLBuffer[] buffers;
    static int[] origin;
    static int[] region;
    static int totalSum;

    public static void reshape(GL2 gL2, int n, int n2) {
        windowWidth = n;
        windowHeight = n2;
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glViewport(0, 0, n, n2);
        glu.gluPerspective(45.0f, (float)n / (float)n2, 0.5f, 10.0f);
    }

    public static void renderScene(GL2 gL2) {
        gL2.glClear(0x100 | 0x4000);
        if (extractSurfaceOnEveryFrame || extractSurface) {
            gL2.glDeleteBuffers(1, VBO_ID, 0);
            int[] nArray = new int[8];
            if (writingTo3DTextures) {
                queue.putMapImage(images[images.length - 1], CLMemory.Map.READ, origin[0], origin[1], origin[2], region[0], region[1], region[2], false);
            } else {
                queue.putMapBuffer(buffers[buffers.length - 1], CLMemory.Map.READ, 0L, 32L, false);
            }
            queue.finish();
            totalSum = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] + nArray[5] + nArray[6] + nArray[7];
            if (totalSum == 0) {
                System.out.println("No triangles were extracted. Check isovalue.");
                return;
            }
            gL2.glGenBuffers(1, VBO_ID, 0);
            gL2.glBindBuffer(34962, VBO_ID[0]);
            gL2.glBufferData(34962, (long)(totalSum * 18 * 4), null, 35044);
            gL2.glBindBuffer(34962, 0);
        }
        Main.reshape(gL2, windowWidth, windowHeight);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glTranslatef(-camX, -camY, -camZ);
        gL2.glRotatef(xrot, 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(yrot, 0.0f, 1.0f, 0.0f);
        gL2.glPushMatrix();
        gL2.glColor3f(1.0f, 1.0f, 1.0f);
        gL2.glScalef(Main.scalingFactor.x, Main.scalingFactor.y, Main.scalingFactor.z);
        gL2.glTranslatef(Main.translation.x, Main.translation.y, Main.translation.z);
        gL2.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        gL2.glBindBuffer(34962, VBO_ID[0]);
        gL2.glEnableClientState(32884);
        gL2.glEnableClientState(32885);
        gL2.glVertexPointer(3, 5126, 24, 0L);
        gL2.glNormalPointer(5126, 24, 12L);
        if (extractSurfaceOnEveryFrame || extractSurface) {
            queue.finish();
        }
        gL2.glDrawArrays(4, 0, totalSum * 3);
        gL2.glBindBuffer(34962, 0);
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32885);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glColor3f(1.0f, 1.0f, 0.0f);
        gL2.glPopMatrix();
        extractSurface = false;
    }

    public static void main(String[] stringArray) {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        gLJPanel.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                int n = gLAutoDrawable.getSurfaceWidth();
                int n2 = gLAutoDrawable.getSurfaceHeight();
                windowWidth = n;
                windowHeight = n2;
                gL2.glMatrixMode(5889);
                gL2.glLoadIdentity();
                gL2.glViewport(0, 0, n, n2);
                glu.gluPerspective(45.0f, (float)n / (float)n2, 0.5f, 10.0f);
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                Main.renderScene(gLAutoDrawable.getGL().getGL2());
            }
        });
        final JFrame jFrame = new JFrame("GPU Marching Cubes");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add((Component)gLJPanel, "Center");
        jFrame.setSize(640, 480);
        jFrame.setVisible(true);
    }

    static {
        glu = new GLU();
        VBO_ID = new int[]{0};
        extractSurfaceOnEveryFrame = true;
        camZ = 4.0f;
        speed = 0.1f;
    }
}

