/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.glu.GLU;
import eazycnc.gcode.FilePos;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.FloatBuffer;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import virtualmill3ax.GLShape;

public class OpenGLWindow
implements GLEventListener {
    private int m_ImageNo = 0;
    public GLJPanel m_OpenGLPanel;
    Point3f m_LookFrom = new Point3f(0.0f, -1.0f, 0.0f);
    Vector3f m_Up = new Vector3f(0.0f, 0.0f, 1.0f);
    Point3f m_LookAt = new Point3f(0.0f, 0.0f, 0.0f);
    private volatile GLShape m_HeightMap;
    private FilePos m_FilePos;
    GLShape m_Sphere = GLShape.createSphere(0.05f, 16, 16);
    private double m_Rotation = Math.toRadians(30.0);
    private double m_Tilt = Math.toRadians(-45.0);
    private int m_Width;
    private int m_Height;
    private float m_Zoom = 1000.0f;
    private float m_ZoomFactor = 1.1f;
    private float[] m_ViewPort = new float[4];
    private float[] m_ViewMat = new float[16];
    private float[] m_ProjectionMat = new float[16];
    private float m_IndicatorSize = 0.1f;
    private GLU m_GLU;
    private GLShape m_Xindicator = GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, this.m_IndicatorSize, 0.0f, 0.0f});
    private GLShape m_Yindicator = GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.m_IndicatorSize, 0.0f});
    private GLShape m_Zindicator = GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, this.m_IndicatorSize});
    double m_GridSpacing;
    float m_CharWidth = 0.02f;
    float m_CharHeight = 0.04f;
    GLShape m_XLetter = GLShape.createLines(new float[]{-this.m_CharWidth, -this.m_CharHeight, 0.0f, this.m_CharWidth, this.m_CharHeight, 0.0f, -this.m_CharWidth, this.m_CharHeight, 0.0f, this.m_CharWidth, -this.m_CharHeight, 0.0f});
    GLShape m_YLetter = GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, -this.m_CharWidth, this.m_CharHeight, 0.0f, 0.0f, 0.0f, 0.0f, this.m_CharWidth, this.m_CharHeight, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -this.m_CharHeight, 0.0f});
    GLShape m_ZLetter = GLShape.createLines(new float[]{-this.m_CharWidth, this.m_CharHeight, 0.0f, this.m_CharWidth, this.m_CharHeight, 0.0f, this.m_CharWidth, this.m_CharHeight, 0.0f, -this.m_CharWidth, -this.m_CharHeight, 0.0f, -this.m_CharWidth, -this.m_CharHeight, 0.0f, this.m_CharWidth, -this.m_CharHeight, 0.0f});
    int count = 0;
    int m_PrevX;
    int m_PrevY;

    public static void glLoadMatrix(float[] fArray, Matrix4d matrix4d) {
        fArray[0] = (float)matrix4d.m00;
        fArray[1] = (float)matrix4d.m10;
        fArray[2] = (float)matrix4d.m20;
        fArray[3] = (float)matrix4d.m30;
        fArray[4] = (float)matrix4d.m01;
        fArray[5] = (float)matrix4d.m11;
        fArray[6] = (float)matrix4d.m21;
        fArray[7] = (float)matrix4d.m31;
        fArray[8] = (float)matrix4d.m02;
        fArray[9] = (float)matrix4d.m12;
        fArray[10] = (float)matrix4d.m22;
        fArray[11] = (float)matrix4d.m32;
        fArray[12] = (float)matrix4d.m03;
        fArray[13] = (float)matrix4d.m13;
        fArray[14] = (float)matrix4d.m23;
        fArray[15] = (float)matrix4d.m33;
    }

    public static void glOrtho(Matrix4d matrix4d, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = -(d2 + d) / (d2 - d);
        double d8 = -(d4 + d3) / (d4 - d3);
        double d9 = -(d6 + d5) / (d6 - d5);
        matrix4d.m00 = 2.0 / (d2 - d);
        matrix4d.m01 = 0.0;
        matrix4d.m02 = 0.0;
        matrix4d.m03 = d7;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = -2.0 / (d4 - d3);
        matrix4d.m12 = 0.0;
        matrix4d.m13 = d8;
        matrix4d.m20 = 0.0;
        matrix4d.m21 = 0.0;
        matrix4d.m22 = 2.0 / (d6 - d5);
        matrix4d.m23 = d9;
        matrix4d.m30 = 0.0;
        matrix4d.m31 = 0.0;
        matrix4d.m32 = 0.0;
        matrix4d.m33 = 1.0;
    }

    public static final void lookAt(Matrix4d matrix4d, Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3) {
        Vector3d vector3d = new Vector3d();
        vector3d.x = tuple3f.x - tuple3f2.x;
        vector3d.y = tuple3f.y - tuple3f2.y;
        vector3d.z = tuple3f.z - tuple3f2.z;
        vector3d.normalize();
        Vector3d vector3d2 = new Vector3d(tuple3f3);
        vector3d2.negate();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d2, vector3d);
        vector3d2.cross(vector3d, vector3d3);
        vector3d3.normalize();
        vector3d2.normalize();
        matrix4d.setIdentity();
        matrix4d.m00 = vector3d3.x;
        matrix4d.m01 = vector3d3.y;
        matrix4d.m02 = vector3d3.z;
        matrix4d.m10 = vector3d2.x;
        matrix4d.m11 = vector3d2.y;
        matrix4d.m12 = vector3d2.z;
        matrix4d.m20 = vector3d.x;
        matrix4d.m21 = vector3d.y;
        matrix4d.m22 = vector3d.z;
        Vector3d vector3d4 = new Vector3d(tuple3f);
        vector3d4.negate();
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setIdentity();
        matrix4d2.setTranslation(vector3d4);
        matrix4d.mul(matrix4d, matrix4d2);
    }

    public OpenGLWindow() {
    }

    public OpenGLWindow(FloatBuffer floatBuffer, int n, int n2) {
        float[] fArray = new float[floatBuffer.limit()];
        floatBuffer.rewind();
        floatBuffer.get(fArray);
        this.m_HeightMap = GLShape.createHeightMap(n, n2, 1.0f, 1.0f, fArray);
    }

    public OpenGLWindow(float[] fArray, int n, int n2) {
        this.m_HeightMap = GLShape.createHeightMap(n, n2, 1.0f, 1.0f, fArray);
    }

    private void setupViewMatrixes(GL gL) {
        this.m_ViewPort[0] = 0.0f;
        this.m_ViewPort[1] = 0.0f;
        this.m_ViewPort[2] = this.m_Width;
        this.m_ViewPort[3] = this.m_Height;
        Matrix4d matrix4d = new Matrix4d();
        Point3f point3f = new Point3f(this.m_LookFrom);
        Vector3f vector3f = new Vector3f(this.m_Up);
        point3f.sub((Tuple3f)this.m_LookAt);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.rotX(this.m_Tilt);
        matrix4d2.transform(point3f, point3f);
        Matrix4d matrix4d3 = new Matrix4d();
        matrix4d3.rotZ(this.m_Rotation);
        matrix4d3.transform(point3f, point3f);
        point3f.add((Tuple3f)this.m_LookAt);
        OpenGLWindow.lookAt(matrix4d, (Tuple3f)point3f, (Tuple3f)this.m_LookAt, (Tuple3f)vector3f);
        Matrix4d matrix4d4 = new Matrix4d();
        double d = (double)this.m_Width / (double)this.m_Height;
        OpenGLWindow.glOrtho(matrix4d4, 1.0 * d * (double)this.m_Zoom, -1.0 * d * (double)this.m_Zoom, -1.0 * (double)this.m_Zoom, 1.0 * (double)this.m_Zoom, 1000.0, -1000.0);
        OpenGLWindow.glLoadMatrix(this.m_ViewMat, matrix4d);
        OpenGLWindow.glLoadMatrix(this.m_ProjectionMat, matrix4d4);
    }

    static void printMat(float[] fArray) {
        for (int i = 0; i < 16; ++i) {
            System.out.printf("%8.3f", Float.valueOf(fArray[i]));
            if ((i + 1) % 4 != 0) continue;
            System.out.println();
        }
    }

    public void renderAxisIndicators(GL2 gL2) {
        gL2.glMatrixMode(5889);
        gL2.glLoadMatrixf(this.m_ProjectionMat, 0);
        float f = 1.0f - 2.0f * this.m_IndicatorSize;
        gL2.glTranslatef(f * this.m_Zoom * (float)this.m_Width / (float)this.m_Height, f * this.m_Zoom, 0.0f);
        gL2.glMatrixMode(5888);
        gL2.glLoadMatrixf(this.m_ViewMat, 0);
        gL2.glTranslatef(this.m_LookAt.x, this.m_LookAt.y, this.m_LookAt.z);
        gL2.glScalef(this.m_Zoom, this.m_Zoom, this.m_Zoom);
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        this.m_Xindicator.render(gL2);
        gL2.glColor3f(0.0f, 1.0f, 0.0f);
        this.m_Yindicator.render(gL2);
        gL2.glColor3f(0.0f, 0.0f, 1.0f);
        this.m_Zindicator.render(gL2);
        float[] fArray = new float[3];
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        int[] nArray = new int[]{-1, -1, 2, 2};
        gL2.glGetFloatv(2983, fArray3, 0);
        gL2.glGetFloatv(2982, fArray2, 0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glPushMatrix();
        this.m_GLU.gluProject(this.m_IndicatorSize * 2.0f, 0.0f, 0.0f, fArray2, 0, fArray3, 0, nArray, 0, fArray, 0);
        gL2.glTranslatef(fArray[0], fArray[1], 0.0f);
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        this.m_XLetter.render(gL2);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        this.m_GLU.gluProject(0.0f, this.m_IndicatorSize * 2.0f, 0.0f, fArray2, 0, fArray3, 0, nArray, 0, fArray, 0);
        gL2.glTranslatef(fArray[0], fArray[1], 0.0f);
        gL2.glColor3f(0.0f, 1.0f, 0.0f);
        this.m_YLetter.render(gL2);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        this.m_GLU.gluProject(0.0f, 0.0f, this.m_IndicatorSize * 2.0f, fArray2, 0, fArray3, 0, nArray, 0, fArray, 0);
        gL2.glTranslatef(fArray[0], fArray[1], 0.0f);
        gL2.glColor3f(0.0f, 0.0f, 1.0f);
        this.m_ZLetter.render(gL2);
        gL2.glPopMatrix();
    }

    public void updateHeightMap(GLShape gLShape, FilePos filePos) {
        this.m_HeightMap = gLShape;
        this.m_FilePos = filePos;
        this.m_OpenGLPanel.repaint();
    }

    void renderHeightMap(GL2 gL2) {
        gL2.glColor3f(0.5f, 0.5f, 0.5f);
        this.m_HeightMap.render(gL2);
    }

    void render(GL2 gL2) {
        this.setupViewMatrixes((GL)gL2);
        int n = 0;
        n |= 0x100;
        gL2.glClear(n |= 0x4000);
        gL2.glClear(16384);
        gL2.glClear(256);
        gL2.glEnable(2929);
        gL2.glEnable(2848);
        gL2.glLineWidth(2.0f);
        gL2.glCullFace(1029);
        gL2.glViewport(0, 0, this.m_Width, this.m_Height);
        gL2.glMatrixMode(5889);
        gL2.glLoadMatrixf(this.m_ProjectionMat, 0);
        gL2.glMatrixMode(5888);
        gL2.glLoadMatrixf(this.m_ViewMat, 0);
        float[] fArray = new float[]{0.9f, 0.9f, 0.9f, 0.9f};
        float[] fArray2 = new float[]{0.01f, 0.01f, 0.01f, 0.1f};
        float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        fArray3[0] = this.m_LookFrom.x - 10.0f;
        fArray3[1] = this.m_LookFrom.y;
        fArray3[2] = this.m_LookFrom.z + 10.0f;
        gL2.glBlendFunc(770, 771);
        gL2.glEnable(3042);
        gL2.glEnable(2848);
        gL2.glLineWidth(1.0f);
        gL2.glLightfv(16384, 4609, fArray, 0);
        gL2.glLightfv(16384, 4608, fArray2, 0);
        gL2.glEnable(16384);
        gL2.glEnable(2896);
        gL2.glLightfv(16384, 4611, fArray3, 0);
        gL2.glEnable(2903);
        this.renderHeightMap(gL2);
        GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, 1000.0f, 0.0f, 0.0f}).render(gL2);
        GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 500.0f, 0.0f}).render(gL2);
        GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 250.0f}).render(gL2);
        gL2.glDisable(2929);
        gL2.glDisable(16384);
        gL2.glDisable(2896);
        this.renderAxisIndicators(gL2);
    }

    public void onSwipe(boolean bl, int n, int n2, boolean bl2) {
        if (bl) {
            this.m_PrevX = n;
            this.m_PrevY = n2;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        f = (float)n - (float)this.m_PrevX;
        f2 = (float)n2 - (float)this.m_PrevY;
        this.m_Rotation -= (double)f / 200.0;
        this.m_Tilt -= (double)f2 / 100.0;
        if (this.m_Tilt > (double)((float)Math.toRadians(89.9))) {
            this.m_Tilt = (float)Math.toRadians(89.9);
        }
        if (this.m_Tilt < (double)((float)Math.toRadians(-89.9))) {
            this.m_Tilt = (float)Math.toRadians(-89.9);
        }
        this.m_PrevX = n;
        this.m_PrevY = n2;
        this.m_OpenGLPanel.repaint();
    }

    public void onPinch(int n) {
        float f = 0.1f;
        if (n > 0) {
            this.m_Zoom *= this.m_ZoomFactor;
        }
        if (n < 0) {
            this.m_Zoom /= this.m_ZoomFactor;
        }
        this.m_OpenGLPanel.repaint();
    }

    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame(this.getClass().getSimpleName());
                OpenGLWindow.this.m_OpenGLPanel = new GLJPanel();
                jFrame.add((Component)OpenGLWindow.this.m_OpenGLPanel);
                OpenGLWindow.this.m_OpenGLPanel.addGLEventListener((GLEventListener)OpenGLWindow.this);
                OpenGLWindow.this.m_OpenGLPanel.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        OpenGLWindow.this.onSwipe(true, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isAltDown());
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        OpenGLWindow.this.onSwipe(false, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isAltDown());
                    }
                });
                OpenGLWindow.this.m_OpenGLPanel.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                        OpenGLWindow.this.onSwipe(false, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isAltDown());
                    }
                });
                OpenGLWindow.this.m_OpenGLPanel.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                        OpenGLWindow.this.onPinch(mouseWheelEvent.getWheelRotation());
                    }
                });
                jFrame.setLocation(new Point(100, 100));
                jFrame.setSize(800, 450);
                jFrame.setVisible(true);
            }
        });
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.render((GL2)gLAutoDrawable.getGL());
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.m_Width = n3;
        this.m_Height = n4;
        this.m_GLU = new GLU();
    }
}

