/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import java.io.IOException;
import virtualmill3ax.AuxStuff;
import virtualmill3ax.VirtualStock;
import virtualmill3ax.VirtualTool;

public class VirtualMillTest {
    public static void main(String[] stringArray) throws IOException {
        new VirtualMillTest().run();
    }

    private void run() {
        int[] nArray = AuxStuff.loadPath("/Users/nyholku/VirtualMillTest/cutpath.txt");
        int n = 64;
        VirtualStock virtualStock = new VirtualStock(0);
        VirtualTool virtualTool = new VirtualTool(n);
        virtualStock.createSquereStock(-n, -n, -100, 1600 + 2 * n, 600 + 2 * n, 100);
        virtualStock.setTool(virtualTool);
        long l = System.nanoTime();
        virtualStock.queueCut(nArray, 0, 3, nArray.length / 3);
        virtualStock.finalizeCut();
        long l2 = System.nanoTime();
        long l3 = (long)(nArray.length / 3) * (long)n * (long)n;
        long l4 = l2 - l;
        System.out.printf("processed %dM cells in %f s, time per cell %f ns \n", l3 / 1000000L, (double)(l4 / 100000000L) / 10.0, (double)l4 * 10.0 / (double)l3 / 10.0);
        AuxStuff.saveHeightmapToFile(virtualStock.getHeightMap(), "debug.raw");
        AuxStuff.showHeightmapAs3D(virtualStock.getHeightMap(), virtualStock.getSizeX(), virtualStock.getSizeY());
        System.out.println("done!");
    }
}

