/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import java.nio.IntBuffer;
import java.util.Hashtable;
import java.util.Random;
import virtualmill3ax.VirtualTool;

public class VirtualStock {
    private int m_OriginX;
    private int m_OriginY;
    private int m_OriginZ;
    private int m_SizeX;
    private int m_SizeY;
    private int m_SizeZ;
    private ToolCacheEntry m_CurrentTool;
    private CLContext m_Context;
    private CLDevice m_Device;
    private CLCommandQueue m_Queue;
    CLBuffer<IntBuffer> m_StockHeightMapBuffer;
    private Hashtable<VirtualTool, ToolCacheEntry> m_ToolCache = new Hashtable();
    private static final int KERNEL_ARG_TOOL = 0;
    private static final int KERNEL_ARG_STOCK = 1;
    private static final int KERNEL_ARG_POSITIONS = 2;
    private static final int KERNEL_ARG_POSCOUNT = 3;

    public VirtualStock(int n) {
        this.m_Context = CLContext.create();
        CLDevice[] cLDeviceArray = this.m_Context.getDevices();
        if (n < 0 || n >= cLDeviceArray.length) {
            throw new IllegalArgumentException("no such device");
        }
        this.m_Device = cLDeviceArray[n];
        this.m_Queue = this.m_Device.createCommandQueue();
    }

    public void createSquereStock(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        this.m_OriginX = n;
        this.m_OriginY = n2;
        this.m_OriginZ = n3;
        this.m_SizeX = n4;
        this.m_SizeY = n5;
        this.m_SizeZ = n6;
        this.m_ToolCache.clear();
        int[] nArray = new int[this.m_SizeX * this.m_SizeY];
        for (n7 = 0; n7 < nArray.length; ++n7) {
            nArray[n7] = n6;
        }
        for (n7 = 0; n7 < this.m_SizeX; ++n7) {
            nArray[n7 + this.m_SizeX * 0] = 0;
            nArray[n7 + this.m_SizeX * (this.m_SizeY - 1)] = 0;
        }
        for (n7 = 0; n7 < this.m_SizeY; ++n7) {
            nArray[0 + n7 * this.m_SizeX] = 0;
            nArray[this.m_SizeX - 1 + n7 * this.m_SizeX] = 0;
        }
        this.m_StockHeightMapBuffer = this.m_Context.createIntBuffer(nArray.length, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
        ((IntBuffer)this.m_StockHeightMapBuffer.getBuffer()).rewind();
        ((IntBuffer)this.m_StockHeightMapBuffer.getBuffer()).put(nArray);
        ((IntBuffer)this.m_StockHeightMapBuffer.getBuffer()).rewind();
        this.m_Queue.putWriteBuffer(this.m_StockHeightMapBuffer, false);
    }

    void resetKernelArgs() {
    }

    public void setTool(VirtualTool virtualTool) {
        ToolCacheEntry toolCacheEntry = this.m_ToolCache.get(virtualTool);
        if (toolCacheEntry == null) {
            try {
                CLProgram cLProgram = this.m_Context.createProgram(this.getClass().getResourceAsStream("multimill_with_limit_check.cl"));
                int n = virtualTool.getSize();
                cLProgram.build(new String[]{String.format("-Dstock_origin_x=%d", this.m_OriginX), String.format("-Dstock_origin_y=%d", this.m_OriginY), String.format("-Dstock_origin_z=%d", this.m_OriginZ), String.format("-Dstock_size_x=%d", this.m_SizeX), String.format("-Dstock_size_y=%d", this.m_SizeY), String.format("-Dtool_size=%d", n)});
                CLKernel cLKernel = cLProgram.createCLKernel("multimill");
                CLBuffer cLBuffer = this.m_Context.createIntBuffer(n * n, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                this.m_CurrentTool = toolCacheEntry = new ToolCacheEntry(cLKernel, n, (CLBuffer<IntBuffer>)cLBuffer);
                ((IntBuffer)this.m_CurrentTool.m_ToolHeightMapBuffer.getBuffer()).rewind();
                ((IntBuffer)this.m_CurrentTool.m_ToolHeightMapBuffer.getBuffer()).put(virtualTool.getHeightMap());
                this.m_CurrentTool.m_Kernel.setArg(0, this.m_CurrentTool.m_ToolHeightMapBuffer);
                this.m_CurrentTool.m_Kernel.setArg(1, this.m_StockHeightMapBuffer);
                this.m_ToolCache.put(virtualTool, toolCacheEntry);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.m_CurrentTool = toolCacheEntry;
        if (this.m_CurrentTool != null) {
            ((IntBuffer)this.m_CurrentTool.m_ToolHeightMapBuffer.getBuffer()).rewind();
            this.m_Queue.putWriteBuffer(this.m_CurrentTool.m_ToolHeightMapBuffer, false);
        }
    }

    public void queueCut(int[] nArray, int n, int n2, int n3) {
        if (this.m_CurrentTool == null) {
            return;
        }
        int n4 = this.m_CurrentTool.m_ToolSize;
        CLKernel cLKernel = this.m_CurrentTool.m_Kernel;
        long l = System.nanoTime();
        CLBuffer cLBuffer = this.m_Context.createIntBuffer(3 * n3, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
        ((IntBuffer)cLBuffer.getBuffer()).rewind();
        ((IntBuffer)cLBuffer.getBuffer()).put(nArray, 0, 3 * n3);
        ((IntBuffer)cLBuffer.getBuffer()).rewind();
        this.m_Queue.putWriteBuffer(cLBuffer, false);
        cLKernel.setArg(2, (CLMemory)cLBuffer);
        cLKernel.setArg(3, n3);
        this.m_Queue.put2DRangeKernel(cLKernel, 0L, 0L, (long)n4, (long)n4, 0L, 0L);
    }

    public void close() {
        this.m_Context.release();
    }

    public int getSizeX() {
        return this.m_SizeX;
    }

    public int getSizeY() {
        return this.m_SizeY;
    }

    public void finalizeCut() {
        this.m_Queue.finish();
    }

    public int[] getHeightMap() {
        this.m_Queue.finish();
        this.m_Queue.putReadBuffer(this.m_StockHeightMapBuffer, true);
        this.m_Queue.finish();
        int[] nArray = new int[this.m_SizeX * this.m_SizeY];
        ((IntBuffer)this.m_StockHeightMapBuffer.getBuffer()).rewind();
        ((IntBuffer)this.m_StockHeightMapBuffer.getBuffer()).get(nArray);
        ((IntBuffer)this.m_StockHeightMapBuffer.getBuffer()).rewind();
        this.m_Queue.putWriteBuffer(this.m_StockHeightMapBuffer, false);
        if (this.m_CurrentTool != null) {
            ((IntBuffer)this.m_CurrentTool.m_ToolHeightMapBuffer.getBuffer()).rewind();
            this.m_Queue.putWriteBuffer(this.m_CurrentTool.m_ToolHeightMapBuffer, false);
            this.m_CurrentTool.m_Kernel.setArg(0, this.m_CurrentTool.m_ToolHeightMapBuffer);
            this.m_CurrentTool.m_Kernel.setArg(1, this.m_StockHeightMapBuffer);
        }
        return nArray;
    }

    public static void main(String ... stringArray) {
        while (true) {
            try {
                block3: while (true) {
                    int n;
                    int n2 = 100000;
                    Random random = new Random();
                    int[] nArray = new int[n2 * 3];
                    int n3 = 0;
                    for (n = 0; n < n2; ++n) {
                        nArray[n3++] = (int)(random.nextDouble() * 800.0 + 100.0);
                        nArray[n3++] = (int)(random.nextDouble() * 800.0 + 100.0);
                        nArray[n3++] = (int)(random.nextDouble() * 200.0 + 20.0);
                    }
                    n = 0;
                    while (true) {
                        if (n >= 3) continue block3;
                        VirtualStock virtualStock = new VirtualStock(n);
                        System.out.print("dev " + n + " ");
                        VirtualTool virtualTool = new VirtualTool(32);
                        virtualStock.createSquereStock(0, 0, 0, 1000, 1000, 200);
                        virtualStock.setTool(virtualTool);
                        long l = System.nanoTime();
                        virtualStock.queueCut(nArray, 0, 3, n2);
                        virtualStock.finalizeCut();
                        long l2 = System.nanoTime();
                        System.out.println(l2 - l);
                        virtualStock.close();
                        ++n;
                    }
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            break;
        }
    }

    static class ToolCacheEntry {
        CLKernel m_Kernel;
        int m_ToolSize;
        CLBuffer<IntBuffer> m_ToolHeightMapBuffer;

        ToolCacheEntry(CLKernel cLKernel, int n, CLBuffer<IntBuffer> cLBuffer) {
            this.m_Kernel = cLKernel;
            this.m_ToolSize = n;
            this.m_ToolHeightMapBuffer = cLBuffer;
        }
    }
}

