/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLProgram;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import virtualmill3ax.OpenGLWindow;

public class VirtualStockOriginal {
    static final double resolution = 0.1;
    static final int tool_size = 30;
    static final int stock_size_x = 2000;
    static final int stock_size_y = 1200;
    static final boolean usefloat = false;
    static final int iscale = 10000;
    private static final String kernelFunction_int = "kernel void millcut_int(\t\t\t\t\t\t\t\t\t\t\t\t\t\tglobal const int* tool, \t\t\t\t\t\t\t\t\t\t\t \tglobal int* stock, \t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_x, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_y, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_z \t\t\t\t\t\t\t\t\t\t\t\t\t\t \t) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \tint x=get_global_id(0);\t\t\t\t\t\t\t\t\t\t\t\t \tint y=get_global_id(1);\t\t\t\t\t\t\t\t\t\t\t\t \tint si = (x + tool_pos_x) + (y + tool_pos_y) * stock_size;\t\t\t\tint ti = x + y * tool_size;\t\t\t\t\t\t\t\t\t\t\t\tint h=tool[ti]+tool_pos_z;\t\t\t\t\t\t\t\t\t\t\t\tif (stock[si] > h)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tstock[si] = h;\t\t\t\t\t\t\t\t\t\t\t\t\t}";
    private static final String kernelFunction_float = "kernel void millcut_float(\t\t\t\t\t\t\t\t\t\t\t\t\t\tglobal const float* tool, \t\t\t\t\t\t\t\t\t\t\t \tglobal float* stock, \t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_x, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_y, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_z \t\t\t\t\t\t\t\t\t\t\t\t\t\t \t) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \tint x=get_global_id(0);\t\t\t\t\t\t\t\t\t\t\t\t \tint y=get_global_id(1);\t\t\t\t\t\t\t\t\t\t\t\t \tint si = (x + tool_pos_x) + (y + tool_pos_y) * stock_size;\t\t\t\tint ti = x + y * tool_size;\t\t\t\t\t\t\t\t\t\t\t\tfloat h=tool[ti]+tool_pos_z;\t\t\t\t\t\t\t\t\t    \tif (stock[si] > h)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tstock[si] = h;\t\t\t\t\t\t\t\t\t\t\t\t\t}";
    private static final String kernelFunctiony = "kernel void millcut(\t\t\t\t\t\t\t\t\t\t\t\t\t\tglobal const float* tool, \t\t\t\t\t\t\t\t\t\t\t \tglobal float* stock, \t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_x, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_y, \t\t\t\t\t\t\t\t\t\t\t\t\t \tint tool_pos_z \t\t\t\t\t\t\t\t\t\t\t\t\t\t \t) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \tint x=get_global_id(0);\t\t\t\t\t\t\t\t\t\t\t\t \tint y=get_global_id(1);\t\t\t\t\t\t\t\t\t\t\t\t \tint si = (x + tool_pos_x) + (y + tool_pos_y) * stock_size;\t\t\t\tstock[si] = 0.0f;\t\t\t\t\t\t\t\t\t\t\t\t\t}";

    public static void main(String[] stringArray) throws IOException {
        new VirtualStockOriginal().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        try {
            float[][] fArray = this.loadPath("/Users/nyholku/EazyCNC-Project/cutpath.txt");
            boolean bl = Platform.AWT_AVAILABLE;
            CLContext cLContext = CLContext.create();
            System.out.println("created " + cLContext);
            try {
                int n;
                CLDevice cLDevice2;
                for (CLDevice cLDevice2 : cLContext.getDevices()) {
                    System.out.println("available device " + cLDevice2);
                }
                CLDevice cLDevice3 = cLContext.getDevices()[0];
                System.out.println("using " + cLDevice3);
                CLCommandQueue cLCommandQueue = cLDevice3.createCommandQueue();
                CLProgram cLProgram = cLContext.createProgram(kernelFunction_int);
                cLProgram.build(new String[]{String.format("-Dstock_size=%d", 2000), String.format("-Dtool_size=%d", 30)});
                cLDevice2 = null;
                Object var8_11 = null;
                CLBuffer cLBuffer = null;
                CLBuffer cLBuffer2 = null;
                cLBuffer = cLContext.createIntBuffer(900, new CLMemory.Mem[]{CLMemory.Mem.READ_ONLY});
                cLBuffer2 = cLContext.createIntBuffer(2400000, new CLMemory.Mem[]{CLMemory.Mem.READ_WRITE});
                VirtualStockOriginal.fillBuffer((IntBuffer)cLBuffer2.getBuffer(), 500000);
                System.out.println("used device memory: " + (cLBuffer.getCLSize() + cLBuffer2.getCLSize()) / 1000000L + "MB");
                ((IntBuffer)cLBuffer.getBuffer()).rewind();
                ((IntBuffer)cLBuffer.getBuffer()).put(VirtualStockOriginal.asInt(VirtualStockOriginal.createToolHeightMap(30, false), 10000));
                ((IntBuffer)cLBuffer.getBuffer()).rewind();
                CLKernel cLKernel = cLProgram.createCLKernel("millcut_int");
                cLKernel.putArg((CLMemory)cLBuffer);
                cLKernel.putArg((CLMemory)cLBuffer2);
                cLCommandQueue.putWriteBuffer(cLBuffer, false);
                cLCommandQueue.putWriteBuffer(cLBuffer2, false);
                long l = 0L;
                long l2 = System.nanoTime();
                int n2 = fArray[0].length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = (int)(fArray[0][i] * 10.0f + 30.0f);
                    int n4 = (int)((60.0f - fArray[1][i]) * 10.0f + 30.0f);
                    n = (int)(fArray[2][i] * 10.0f + 50.0f) * 10000;
                    cLKernel.setArg(2, n3);
                    cLKernel.setArg(3, n4);
                    cLKernel.setArg(4, n);
                    cLCommandQueue.put2DRangeKernel(cLKernel, 0L, 0L, 30L, 30L, 0L, 0L);
                }
                l = System.nanoTime() - l2;
                System.out.println("submitting computation took: " + l / 1000000L + " ms");
                cLCommandQueue.finish();
                l = System.nanoTime() - l2;
                cLCommandQueue.putReadBuffer(cLBuffer2, true).finish();
                System.out.println("total computation took: " + l / 1000000L + "ms");
                System.out.printf("time per height op %1.1f ns\n", (double)l / (double)(900 * n2));
                System.out.println("tool pos / sec " + (long)n2 * 1000000000L / l);
                System.out.printf("tool speed %1.1f mm/s", (double)((long)n2 * 1000000000L / l) * 0.1);
                System.out.printf("tool diameter %1.1f mm\n", 3.0);
                System.out.printf("stock size %1.1f x %1.1f mm2\n", 200.0, 120.0);
                byte[] byArray = new byte[2400000];
                Object object = new float[byArray.length];
                IntBuffer intBuffer = (IntBuffer)cLBuffer2.getBuffer();
                for (n = 0; n < byArray.length; ++n) {
                    byArray[n] = (byte)(intBuffer.get(n) / 10000 * 2);
                    object[n] = intBuffer.get(n) / 10000 * 2;
                }
                new OpenGLWindow((float[])object, 2000, 1200).run();
                object = VirtualStockOriginal.getGrayscale(2000, 1200, byArray);
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ BufferedImage val$image;
                    {
                        this.val$image = bufferedImage;
                    }

                    @Override
                    public void run() {
                        JFrame jFrame = new JFrame(this.getClass().getSimpleName()){

                            @Override
                            public void paint(Graphics graphics) {
                                super.paint(graphics);
                                graphics.drawImage(val$image, 0, 0, null);
                            }
                        };
                        jFrame.setLocationRelativeTo(null);
                        jFrame.setSize(1600, 1200);
                        jFrame.setVisible(true);
                    }
                });
            }
            finally {
                cLContext.release();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static BufferedImage getGrayscale(int n, int n2, byte[] byArray) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] nArray = new int[]{8};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 0);
        SampleModel sampleModel = ((ColorModel)componentColorModel).createCompatibleSampleModel(n, n2);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    private static void fillBuffer(FloatBuffer floatBuffer, float f) {
        while (floatBuffer.remaining() != 0) {
            floatBuffer.put(f);
        }
        floatBuffer.rewind();
    }

    private static void fillBuffer(IntBuffer intBuffer, int n) {
        while (intBuffer.remaining() != 0) {
            intBuffer.put(n);
        }
        intBuffer.rewind();
    }

    public static float[] createToolHeightMap(int n, boolean bl) {
        int n2 = n / 2;
        float[] fArray = new float[n * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = (double)(j - n2) + 0.5;
                double d2 = (double)(i - n2) + 0.5;
                double d3 = (double)(n2 * n2) - d * d - d2 * d2;
                d3 = d3 >= 0.0 ? (bl ? (double)n2 - Math.sqrt(d3) : 0.0) : 65535.0;
                fArray[j + i * n] = (float)d3;
            }
        }
        return fArray;
    }

    private static int[] asInt(float[] fArray, int n) {
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = (int)(fArray[i] * (float)n);
        }
        return nArray;
    }

    public float[][] loadPath(String string) {
        try {
            int n;
            String string2;
            ArrayList<Float> arrayList = new ArrayList<Float>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                n = 0;
                arrayList.add(Float.valueOf(Float.parseFloat(string2.substring(n, n + 9))));
                arrayList.add(Float.valueOf(Float.parseFloat(string2.substring(n += 9, n + 9))));
                arrayList.add(Float.valueOf(Float.parseFloat(string2.substring(n += 9, n + 9))));
                n += 9;
            }
            n = arrayList.size() / 3;
            System.out.println("read in " + n + " tuplets");
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            float[] fArray3 = new float[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                fArray[i] = ((Float)arrayList.get(n2++)).floatValue();
                fArray2[i] = ((Float)arrayList.get(n2++)).floatValue();
                fArray3[i] = ((Float)arrayList.get(n2++)).floatValue();
            }
            return new float[][]{fArray, fArray2, fArray3};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

