/*
 * Decompiled with CFR 0.152.
 */
package virtualmill3ax;

import virtualmill3ax.AuxStuff;

public final class VirtualTool {
    public static final int MAX_TOOL_VALUE = 0xFFFFFFF;
    private int m_Size;
    private double m_D;
    private double m_R;
    private double m_Rr;
    private double m_Rz;
    private double m_h;
    private double m_a;
    private double m_b;
    private int[] m_HeightMap;

    public VirtualTool(int n) {
        this.m_Size = n;
        double[] dArray = VirtualTool.createToolHeightMap(n, false);
        this.m_HeightMap = new int[n * n];
        for (int i = 0; i < dArray.length; ++i) {
            this.m_HeightMap[i] = (int)(0.5 + dArray[i]);
        }
    }

    public VirtualTool(double d, double d2, double d3, double d4, double d5) {
        int n;
        if (d == d2 && d5 != 0.0) {
            throw new IllegalArgumentException("Ds == D && b != 0");
        }
        if (d != d2 && d5 == 0.0) {
            throw new IllegalArgumentException("Ds != D && b == 0");
        }
        if (d5 < 0.0) {
            throw new IllegalArgumentException("b < 0");
        }
        if (d5 >= 1.5707963267948966) {
            throw new IllegalArgumentException("b >= PI/2");
        }
        if (d < d2) {
            throw new IllegalArgumentException("Ds < D");
        }
        if (d4 <= -1.5707963267948966) {
            throw new IllegalArgumentException("a <= -PI/2");
        }
        if (d4 >= 1.5707963267948966) {
            throw new IllegalArgumentException("a >= PI/2");
        }
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{d2 / 2.0, d2 / 2.0 * Math.tan(d4)};
        double[] dArray3 = new double[]{d / 2.0, dArray2[1] + (d - d2) / 2.0 / Math.tan(d5)};
        if (d == d2 && d5 == 0.0) {
            dArray3[1] = dArray2[1] + 1.0;
        }
        if (dArray3[1] >= 2.68435455E8) {
            throw new IllegalArgumentException("Ds - D too high in rel to b ");
        }
        double[] dArray4 = VirtualTool.direction(dArray, dArray2);
        double[] dArray5 = VirtualTool.direction(dArray2, dArray3);
        double[] dArray6 = VirtualTool.intersect(VirtualTool.offset(dArray, dArray4, d3), dArray4, VirtualTool.offset(dArray2, dArray5, d3), dArray5);
        double[] dArray7 = VirtualTool.intersect(dArray, dArray4, dArray6, VirtualTool.ortho(dArray4));
        double[] dArray8 = VirtualTool.intersect(dArray2, dArray5, dArray6, VirtualTool.ortho(dArray5));
        double d6 = dArray7[0];
        double d7 = dArray6[0];
        double d8 = dArray8[0];
        double d9 = dArray3[0];
        int n2 = (int)Math.ceil(d9);
        int n3 = 2 * n2 + 1;
        int n4 = Integer.MAX_VALUE;
        int[] nArray = new int[n3 * n3];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = Integer.MIN_VALUE;
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n3; ++i) {
                double d10;
                double d11 = i - n2;
                double d12 = n - n2;
                double d13 = Math.sqrt(d11 * d11 + d12 * d12);
                if (d13 < d6) {
                    d10 = dArray7[1] * d13 / d6;
                } else if (d13 <= d8) {
                    double d14 = d13 - d7;
                    d10 = dArray6[1] - Math.sqrt(d3 * d3 - d14 * d14);
                } else {
                    if (!(d13 < d9)) continue;
                    d10 = dArray8[1] + (d13 - d8) / Math.sin(d5);
                }
                int n5 = (int)(d10 + 0.5);
                if (n5 < n4) {
                    n4 = n5;
                }
                nArray[i + n * n3] = n5;
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == Integer.MIN_VALUE) {
                nArray[n] = 0xFFFFFFF;
                continue;
            }
            int n6 = n;
            nArray[n6] = nArray[n6] - n4;
        }
        this.m_HeightMap = nArray;
        this.m_Size = n3;
    }

    private static void test1() {
        VirtualTool virtualTool = new VirtualTool(100.0, 100.0, 50.0, Math.toRadians(0.0), Math.toRadians(0.0));
        System.out.println(virtualTool.m_Size);
        AuxStuff.saveHeightmapToFile(virtualTool.m_HeightMap, "test1.raw");
    }

    private static void test2() {
        VirtualTool virtualTool = new VirtualTool(100.0, 100.0, 0.0, Math.toRadians(45.0), Math.toRadians(0.0));
        System.out.println(virtualTool.m_Size);
        AuxStuff.saveHeightmapToFile(virtualTool.m_HeightMap, "test2.raw");
    }

    private static void test3() {
        VirtualTool virtualTool = new VirtualTool(100.0, 80.0, 10.0, Math.toRadians(10.0), Math.toRadians(30.0));
        System.out.println(virtualTool.m_Size);
        AuxStuff.saveHeightmapToFile(virtualTool.m_HeightMap, "test3.raw");
    }

    public VirtualTool(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d4 * Math.tan(d6) + d3 + Math.sqrt((VirtualTool.sqr(d2) - VirtualTool.sqr(d3)) * VirtualTool.sqr(Math.tan(d6)) + 2.0 * d4 * d3 * Math.tan(d6) - VirtualTool.sqr(d4) + VirtualTool.sqr(d2))) / (VirtualTool.sqr(Math.tan(d6)) + 1.0);
        double d9 = d8 * Math.tan(d6);
        double d10 = d / 2.0 * (1.0 - Math.tan(d6) * Math.tan(d7));
        double d11 = ((d3 - d10) * Math.tan(d7) + d4 - Math.sqrt((VirtualTool.sqr(d2) - VirtualTool.sqr(d4)) * VirtualTool.sqr(Math.tan(d7)) + 2.0 * d4 * (d3 - d10) * Math.tan(d7) - VirtualTool.sqr(d3 - d10) + VirtualTool.sqr(d2))) / (VirtualTool.sqr(Math.tan(d7)) + 1.0);
        double d12 = d10 + d11 * Math.tan(d7);
    }

    private static double sqr(double d) {
        return d * d;
    }

    public static VirtualTool createCylinderical() {
        return null;
    }

    public static VirtualTool createBallEnd() {
        return null;
    }

    public static VirtualTool createBullNose() {
        return null;
    }

    public static VirtualTool createTapered() {
        return null;
    }

    public static VirtualTool createTaperBallEnd() {
        return null;
    }

    public static VirtualTool createGeneral() {
        return null;
    }

    public static VirtualTool createCone() {
        return null;
    }

    public static VirtualTool createRoundedEnd() {
        return null;
    }

    private static double[] createToolHeightMap(int n, boolean bl) {
        int n2 = n / 2;
        double[] dArray = new double[n * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = (double)(j - n2) + 0.5;
                double d2 = (double)(i - n2) + 0.5;
                double d3 = (double)(n2 * n2) - d * d - d2 * d2;
                d3 = d3 >= 0.0 ? (bl ? (double)n2 - Math.sqrt(d3) : 0.0) : 2.68435455E8;
                dArray[j + i * n] = (float)d3;
            }
        }
        return dArray;
    }

    public static double[] intersect(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d = 0.0;
        double d2 = d * d;
        double d3 = dArray3[0] - dArray[0];
        double d4 = dArray3[1] - dArray[1];
        double d5 = dArray2[0] * dArray4[1] - dArray2[1] * dArray4[0];
        double d6 = d5 * d5;
        double d7 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        double d8 = dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1];
        if (d6 < d2 * d7 * d8) {
            return null;
        }
        double d9 = (d3 * dArray4[1] - d4 * dArray4[0]) / d5;
        return new double[]{dArray[0] + d9 * dArray2[0], dArray[1] + d9 * dArray2[1]};
    }

    private static double[] direction(double[] dArray, double[] dArray2) {
        return new double[]{dArray2[0] - dArray[0], dArray2[1] - dArray[1]};
    }

    private static double[] offset(double[] dArray, double[] dArray2, double d) {
        double d2 = d / Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1]);
        double d3 = -dArray2[1] * d2;
        double d4 = dArray2[0] * d2;
        return new double[]{dArray[0] + d3, dArray[1] + d4};
    }

    private static double[] ortho(double[] dArray) {
        return new double[]{-dArray[1], dArray[0]};
    }

    public static void main(String ... stringArray) {
        VirtualTool.test1();
        VirtualTool.test2();
        VirtualTool.test3();
    }

    public int[] getHeightMap() {
        return this.m_HeightMap;
    }

    public int getSize() {
        return this.m_Size;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof VirtualTool)) {
            return false;
        }
        VirtualTool virtualTool = (VirtualTool)object;
        if (this.m_Size != virtualTool.m_Size) {
            return false;
        }
        if (this.m_D != virtualTool.m_D) {
            return false;
        }
        if (this.m_R != virtualTool.m_R) {
            return false;
        }
        if (this.m_a != virtualTool.m_a) {
            return false;
        }
        return this.m_b == virtualTool.m_b;
    }

    public int hashCode() {
        return (int)((double)(this.m_Size * 53) + this.m_D * 59.0 + this.m_R * 71.0 + this.m_a * 113.0 + this.m_b * 197.0);
    }
}

