kernel void multimill(
   global const int* tool,
   global int* stock,
   global const int* positions,
   int poscount,
   int stock_origin_X,
   int stock_origin_Y,
   int stock_origin_Z
   )

   {
   int x = get_global_id(0);
   int y = get_global_id(1);
   int ti = x + y * tool_size;
   int i = 0;
   int bh = tool[ti];
   while (poscount-- > 0) {
		int tool_pos_x = positions[i++] - stock_origin_X;
		int tool_pos_y = positions[i++] - stock_origin_Y;
		int tool_pos_z = positions[i++] - stock_origin_Z;
		
		int si = (x + tool_pos_x) + (y + tool_pos_y) * stock_size;
   
		int h = bh + tool_pos_z;
        atomic_min(&stock[si],h);
		}
      
   }
 
