kernel void multimill(
   global const int* tool,
   global int* stock,
   global const int* positions,
   int poscount
   )

   {
   int x = get_global_id(0);
   int y = get_global_id(1);
   int ti = x + y * tool_size;
   int i = 0;
   int bh = tool[ti];
   while (poscount-- > 0) {
		int tool_pos_x = positions[i++] - stock_origin_x + x - tool_size/2;
		int tool_pos_y = positions[i++] - stock_origin_y + y - tool_size/2;
		int tool_pos_z = positions[i++] - stock_origin_z + bh;
		
        if ( tool_pos_x < 0) continue;
        if ( tool_pos_x >= stock_size_x) continue;
        if ( tool_pos_y < 0) continue;
        if ( tool_pos_y >= stock_size_y) continue;
       
		int si = tool_pos_x + tool_pos_y * stock_size_x;
   
        atomic_min(&stock[si], tool_pos_z);
		}
      
   }
 
